<?php /* Template Name: Home page */ ?>
<?php get_header(); ?>  
            <section class="home" id="big-video">
                <div class="wrapper">
                    <div class="d_flex home_section">
                        <div class="online_accounting d_flex">
                            <h1><?php the_field('title'); ?></h1>
                            <p>
                                <?php the_field('description'); ?>
                            </p>
                            <a class="request_for_meeting d_flex" href="<?php the_field('buttone_url'); ?>">
                                <?php the_field('button_name'); ?>
                                <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M0 10.5C0 16.3004 4.6996 21 10.5 21C16.3004 21 21 16.3004 21 10.5C21 4.6996 16.3004 0 10.5 0C4.6996 0 0 4.6996 0 10.5ZM18.9677 10.5C18.9677 15.1996 15.1573 18.9677 10.5 18.9677C5.8004 18.9677 2.03226 15.1996 2.03226 10.5C2.03226 5.84274 5.8004 2.03226 10.5 2.03226C15.1573 2.03226 18.9677 5.84274 18.9677 10.5ZM14.3952 10.881C14.6069 10.6694 14.6069 10.373 14.3952 10.1613L9.1875 4.95363C9.01815 4.74194 8.67944 4.74194 8.46774 4.95363L7.53629 5.92742C7.3246 6.09677 7.3246 6.43548 7.53629 6.64718L11.3891 10.5L7.53629 14.3952C7.3246 14.6069 7.3246 14.9032 7.53629 15.1149L8.46774 16.0887C8.67944 16.2581 9.01815 16.2581 9.1875 16.0887L14.3952 10.881Z" fill="white"/>
                                </svg>                                    
                            </a>
                        </div>
                        <div class="to_up_img">
                            <video autoplay muted loop src="<?php echo get_template_directory_uri() ?>/video/0706.mp4"> </video>
                        </div>
                    </div>
                </div>
                <div class="d_flex home_section">
                        <div class="online_accounting d_flex">
                            <h1><?php the_field('title'); ?></h1>
                            <p>
                                <?php the_field('description'); ?>
                            </p>
                            <a class="request_for_meeting d_flex" href="<?php the_field('buttone_url'); ?>">
                                <?php the_field('button_name'); ?>
                                <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M0 10.5C0 16.3004 4.6996 21 10.5 21C16.3004 21 21 16.3004 21 10.5C21 4.6996 16.3004 0 10.5 0C4.6996 0 0 4.6996 0 10.5ZM18.9677 10.5C18.9677 15.1996 15.1573 18.9677 10.5 18.9677C5.8004 18.9677 2.03226 15.1996 2.03226 10.5C2.03226 5.84274 5.8004 2.03226 10.5 2.03226C15.1573 2.03226 18.9677 5.84274 18.9677 10.5ZM14.3952 10.881C14.6069 10.6694 14.6069 10.373 14.3952 10.1613L9.1875 4.95363C9.01815 4.74194 8.67944 4.74194 8.46774 4.95363L7.53629 5.92742C7.3246 6.09677 7.3246 6.43548 7.53629 6.64718L11.3891 10.5L7.53629 14.3952C7.3246 14.6069 7.3246 14.9032 7.53629 15.1149L8.46774 16.0887C8.67944 16.2581 9.01815 16.2581 9.1875 16.0887L14.3952 10.881Z" fill="white"/>
                                </svg>                                    
                            </a>
                        </div>
                </div>
                <div class="fullscreen-video">
                        <video id="video" autoplay="true" muted="true" loop="true" poster="<?php echo get_template_directory_uri() ?>/video/0706.mp4" class="fullscreen-video">
                        <source id="mp4" src="<?php echo get_template_directory_uri() ?>/video/0706.mp4" type="video/mp4"></video>
                </div>
            </section>
            <section class="wrapper services">
                <div class="d_flex col_sec">
                    <div class="link_block d_flex">
                        <div class="green_title"></div>
                        <a class="title_link"> <?php _e( 'Services', 'fintax' ); ?></a>
                    </div>  
                    <h2> </h2>
                    <div class="d_flex row_col">
                        <a href="<?php the_field('but_1'); ?>" class="d_flex for_service_product">
                            <div class="service_products">
                                <div class="d_flex svg_title">
                                    <svg width="86" height="80" viewBox="0 0 86 80" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M3.34087 1.09388C2.18698 1.44695 1.15658 2.31866 0.553828 3.4516C0.253708 4.01582 0.240135 5.08928 0.197907 31.6802C0.149646 62.0836 0.0871422 60.1564 1.16446 61.4633C1.44011 61.7977 2.05761 62.2666 2.5367 62.5054L3.40773 62.9394H17.8696C30.3471 62.9394 32.3317 62.9726 32.3317 63.1807C32.3317 63.8659 30.6546 67.7489 29.4956 69.747L28.9974 70.6058L27.0199 70.6805C25.2811 70.7464 24.9222 70.8127 24.0473 71.2313C22.0055 72.2079 20.7514 74.0673 20.631 76.2963C20.5543 77.7158 20.8799 78.42 21.9088 79.0597L22.5288 79.4452H40.5427C58.2553 79.4452 58.5661 79.4396 59.1255 79.11C60.2923 78.4228 60.7085 77.3689 60.454 75.7465C60.1411 73.7514 58.8485 72.0598 56.9663 71.1826C56.1992 70.8251 55.7139 70.738 54.0457 70.6589L52.0453 70.5639L51.071 68.7206C50.1051 66.8934 48.7537 63.6588 48.7537 63.1745C48.7537 62.9739 48.9487 62.9329 49.7103 62.9729L50.6672 63.0232L50.7975 63.6543C51.1116 65.1736 52.0314 66.2365 53.3619 66.6177C53.8488 66.7572 58.0453 66.796 68.7079 66.7597L83.3836 66.7097L84.2008 66.2045C84.7957 65.8365 85.1454 65.4553 85.4863 64.8028L85.9545 63.9066V45.4704C85.9545 32.1413 85.9015 26.8575 85.7633 26.3958C85.3092 24.8804 83.9275 23.898 82.0623 23.7641L80.935 23.6833L80.8893 13.8606C80.8467 4.73151 80.8219 3.99453 80.5369 3.42161C80.1295 2.60302 79.2729 1.73936 78.4751 1.34339C77.8429 1.02953 76.9391 1.02115 40.794 0.993502C20.4258 0.978085 3.57178 1.02316 3.34087 1.09388ZM77.844 4.02135L78.4138 4.59109V14.1594V23.7277H66.3391C58.0864 23.7277 54.0318 23.7862 53.5296 23.9127C52.6065 24.1451 51.4836 25.0933 51.0806 25.9806C50.7897 26.6212 50.7717 27.3801 50.7682 39.1862L50.7645 51.7121H26.7164H2.66824L2.71181 28.1022C2.75488 4.75933 2.75923 4.48803 3.09052 4.11971C3.27485 3.91477 3.57648 3.68553 3.76081 3.60996C3.94513 3.53455 20.561 3.46803 40.6851 3.46216L77.2743 3.4516L77.844 4.02135ZM5.00469 5.95227L4.51488 6.44208V27.4098C4.51488 49.7336 4.49393 49.1293 5.27649 49.4296C5.42563 49.4868 14.9708 49.5337 26.488 49.5337H47.4283L47.8396 49.1223C48.3639 48.5981 48.3639 47.9557 47.8396 47.4315L47.4283 47.0201H27.2283H7.02844V30.7657V14.5113H40.5427H74.0569V17.4984C74.0569 20.4041 74.0675 20.4954 74.4447 20.8499C74.9593 21.3331 75.6477 21.3142 76.1591 20.8028L76.5705 20.3915V13.5215C76.5705 8.84321 76.5112 6.52101 76.3845 6.24284C76.2821 6.01829 76.0146 5.75085 75.7901 5.64846C75.495 5.51407 65.6908 5.46246 40.4381 5.46246H5.4945L5.00469 5.95227ZM74.0569 9.98688V11.9977H40.5427H7.02844V9.98688V7.97603H40.5427H74.0569V9.98688ZM25.6414 18.0345C24.3783 18.3001 23.2529 18.7147 21.8585 19.428C20.8154 19.9617 20.1647 20.4683 18.9257 21.7113C17.1692 23.4735 16.4171 24.6133 15.7299 26.5552C14.5038 30.0204 14.7464 33.7483 16.4056 36.9302C18.1523 40.2804 20.863 42.4989 24.5458 43.593C26.4451 44.1572 29.2279 44.2281 31.0749 43.7594C37.3412 42.1691 41.5803 36.4586 41.1558 30.1792C40.7788 24.6026 37.1758 20.079 31.7452 18.3634C30.4221 17.9455 26.9532 17.7585 25.6414 18.0345ZM30.2791 35.7469C34.1505 40.5695 33.9984 40.0619 31.8186 40.8823C25.1632 43.3872 18.0468 38.7956 17.4919 31.6386C17.3543 29.8628 17.7334 28.0355 18.6118 26.2413C19.9465 23.5147 22.8319 21.2235 25.657 20.6471L26.7181 20.4304L26.8018 25.9752L26.8856 31.5198L30.2791 35.7469ZM30.9073 20.7416C32.2851 21.0791 34.0042 22.055 35.1876 23.1712C35.8287 23.7762 36.3534 24.327 36.3534 24.3953C36.3534 24.4639 34.867 25.416 33.0504 26.5116C31.2338 27.6072 29.6502 28.5638 29.5314 28.6376C29.3573 28.7455 29.3154 27.9569 29.3154 24.5708V20.3699L29.7762 20.4737C30.0296 20.5308 30.5387 20.6513 30.9073 20.7416ZM83.0295 26.6527L83.4409 27.0639V45.2841V63.5043L83.0766 63.8922L82.7121 64.28H68.3303C54.1717 64.28 53.9432 64.2748 53.6132 63.9448C53.2821 63.6137 53.2781 63.3863 53.2781 45.3369V27.0639L53.6895 26.6527L54.1007 26.2413H68.3595H82.6183L83.0295 26.6527ZM38.2057 27.8751C38.938 30.1906 38.7723 33.081 37.7836 35.2407C37.3196 36.2543 35.9196 38.3064 35.6922 38.3064C35.5866 38.3064 31.9324 33.8381 30.1196 31.4926C30.014 31.3559 31.0848 30.6221 33.7058 29.0345C35.761 27.7898 37.5338 26.7651 37.6454 26.7576C37.7568 26.7502 38.009 27.2529 38.2057 27.8751ZM55.3652 28.9987L54.9538 29.4099V34.087C54.9538 38.5648 54.9685 38.7827 55.3012 39.2054L55.6484 39.647H68.3595H81.0706L81.4178 39.2054C81.7505 38.7827 81.7652 38.5648 81.7652 34.087V29.4099L81.3538 28.9987L80.9426 28.5873H68.3595H55.7764L55.3652 28.9987ZM79.2516 34.1171V37.1334H68.3595H57.4674V34.1171V31.1009H68.3595H79.2516V34.1171ZM55.8587 43.0654L55.2889 43.6352V46.0901C55.2889 49.8263 55.4922 50.0369 59.0958 50.0357C60.9245 50.0352 61.3161 49.9873 61.7741 49.708C62.6694 49.1622 62.8296 48.6402 62.8296 46.2691C62.8296 42.7033 62.6125 42.4957 58.8834 42.4957H56.4284L55.8587 43.0654ZM65.5512 42.7177C64.694 43.1938 64.5891 43.5727 64.5891 46.1896C64.5891 49.768 64.8522 50.0364 68.3595 50.0364C71.8644 50.0364 72.0461 49.8479 72.0461 46.2119V43.6352L71.4763 43.0654L70.9066 42.4957L68.4182 42.5016C66.746 42.5056 65.8055 42.5765 65.5512 42.7177ZM74.6887 42.8251C73.9736 43.3877 73.8587 43.9351 73.9183 46.497L73.9731 48.8579L74.5204 49.4053L75.0679 49.9526L77.4013 50.0071C81.2224 50.0961 81.4895 49.8258 81.4022 45.9586L81.3463 43.4728L80.799 42.9842L80.2517 42.4957H77.6796C75.376 42.4957 75.0639 42.5301 74.6887 42.8251ZM60.3161 46.2661V47.5228H59.0593H57.8025V46.2661V45.0093H59.0593H60.3161V46.2661ZM69.5325 46.2734V47.5376L68.3176 47.4883L67.1027 47.4391L67.0534 46.2242L67.0042 45.0093H68.2683H69.5325V46.2734ZM78.9165 46.2661V47.5228H77.6597H76.4029V46.2661V45.0093H77.6597H78.9165V46.2661ZM56.3472 53.298C55.4429 53.6911 55.2889 54.2299 55.2889 56.999V59.4539L55.8587 60.0237L56.4284 60.5934H58.8834C62.6125 60.5934 62.8296 60.3858 62.8296 56.82C62.8296 54.4489 62.6694 53.9269 61.7741 53.3811C61.3131 53.0999 60.9316 53.0547 59.0593 53.0599C57.5833 53.0639 56.7088 53.1407 56.3472 53.298ZM65.5426 53.3922C64.6476 53.9378 64.4646 54.62 64.5349 57.1485C64.6264 60.4493 64.7899 60.5934 68.444 60.5934H70.9066L71.4763 60.0237L72.0461 59.4539V56.8772C72.0461 53.2003 71.9021 53.0524 68.326 53.0534C66.3862 53.0539 66.0254 53.0978 65.5426 53.3922ZM75.1461 53.2126C74.9618 53.2888 74.6225 53.5537 74.3921 53.8014C73.9919 54.2314 73.9708 54.3597 73.9192 56.6533C73.8347 60.4035 74.0226 60.5934 77.8164 60.5934H80.2517L80.799 60.1049L81.3463 59.6163L81.4001 57.1032C81.4813 53.2963 81.2476 53.0455 77.6344 53.0632C76.4502 53.0691 75.3305 53.1363 75.1461 53.2126ZM50.7645 57.3258V60.4258L27.2627 60.4221C5.248 60.4186 3.73818 60.4 3.40338 60.1289C2.7594 59.6072 2.67159 59.1917 2.67159 56.6665V54.2257H26.7181H50.7645V57.3258ZM60.3161 56.823V58.0798H59.0593H57.8025V56.823V55.5663H59.0593H60.3161V56.823ZM69.5325 56.823V58.0798H68.2757H67.0189V56.9348C67.0189 56.3049 67.0692 55.7394 67.1307 55.678C67.192 55.6165 67.7576 55.5663 68.3875 55.5663H69.5325V56.823ZM78.9165 56.823V58.0798H77.6597H76.4029V56.823V55.5663H77.6597H78.9165V56.823ZM46.6932 65.0236C47.0838 66.1239 47.803 67.8395 48.2915 68.8359L49.1796 70.6477H40.5881C35.8628 70.6477 31.9966 70.6085 31.9966 70.5605C31.9966 70.5126 32.3262 69.8152 32.729 69.0105C33.1318 68.206 33.7783 66.6804 34.1656 65.6205C34.5529 64.5606 34.9384 63.5227 35.0226 63.3141L35.1754 62.9347L40.5792 62.9789L45.9832 63.0232L46.6932 65.0236ZM56.1052 73.6008C57.0975 74.0953 57.7006 74.8705 57.9429 75.9632C58.0587 76.4848 58.045 76.7161 57.8912 76.8438C57.7497 76.9611 52.1234 77.0031 40.4408 76.9743L23.1991 76.9316L23.1409 76.52C22.9871 75.4295 23.9126 74.0673 25.2099 73.4748C25.8425 73.1859 26.704 73.1684 40.5517 73.1649L55.2231 73.1612L56.1052 73.6008Z" fill="#282828"/>
                                        <path d="M78.9165 56.823V58.0798H77.6597H76.4029V56.823V55.5663H77.6597H78.9165V56.823Z" fill="#238DC1"/>
                                        <path d="M30.9073 20.7416C32.2851 21.0791 34.0042 22.055 35.1876 23.1712C35.8287 23.7762 36.3534 24.327 36.3534 24.3953C36.3534 24.4639 34.867 25.416 33.0504 26.5116C31.2338 27.6072 29.6502 28.5638 29.5314 28.6376C29.3573 28.7455 29.3154 27.9569 29.3154 24.5708V20.3699L29.7762 20.4737C30.0296 20.5308 30.5387 20.6513 30.9073 20.7416Z" fill="#238DC1"/>
                                        <path d="M38.2057 27.8751C38.938 30.1906 38.7723 33.081 37.7836 35.2407C37.3196 36.2543 35.9196 38.3064 35.6922 38.3064C35.5866 38.3064 31.9324 33.8381 30.1196 31.4926C30.014 31.3559 31.0848 30.6221 33.7058 29.0345C35.761 27.7898 37.5338 26.7651 37.6454 26.7576C37.7568 26.7502 38.009 27.2529 38.2057 27.8751Z" fill="white"/>
                                        <path d="M74.0569 9.98688V11.9977H40.5427H7.02844V9.98688V7.97603H40.5427H74.0569V9.98688Z" fill="#238DC1"/>
                                        </svg>                                          
                                    <span>
                                        <?php _e( 'Accounting Services', 'fintax' ); ?> </span>
                                </div>
                                   <?php the_field('service_1_descrription'); ?>

                                
                                <div class="d_flex details_block">
                                    <div class="gray_blue_line"></div>
                                    <div class="d_flex details">
                                        <span><?php _e( 'Learn more', 'fintax' ); ?>  </span>
                                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M0.592773 10.6968C0.592773 16.4835 5.28125 21.172 11.0679 21.172C16.8546 21.172 21.5431 16.4835 21.5431 10.6968C21.5431 4.91015 16.8546 0.22168 11.0679 0.22168C5.28125 0.22168 0.592773 4.91015 0.592773 10.6968ZM19.5156 10.6968C19.5156 15.3853 15.7142 19.1445 11.0679 19.1445C6.37945 19.1445 2.62022 15.3853 2.62022 10.6968C2.62022 6.05059 6.37945 2.24913 11.0679 2.24913C15.7142 2.24913 19.5156 6.05059 19.5156 10.6968ZM14.9539 11.077C15.1651 10.8658 15.1651 10.5701 14.9539 10.3589L9.75853 5.16359C9.58958 4.95239 9.25167 4.95239 9.04047 5.16359L8.11123 6.13507C7.90004 6.30402 7.90004 6.64193 8.11123 6.85313L11.9549 10.6968L8.11123 14.5828C7.90004 14.794 7.90004 15.0896 8.11123 15.3008L9.04047 16.2723C9.25167 16.4413 9.58958 16.4413 9.75853 16.2723L14.9539 11.077Z" fill="#282828"/>
                                        </svg>                                        
                                    </div>
                                </div>
                            </div>
                        </a>
                        <a href="<?php the_field('but_2'); ?>" class="d_flex for_service_product">
                            <div class="service_products">
                                <div class="d_flex svg_title big_svg">
                                    <svg width="67" height="86" viewBox="0 0 67 86" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M31.2399 0.229781C29.9259 0.368194 27.2354 0.997425 25.8137 1.49897C18.0287 4.24546 12.2574 10.8699 10.5415 19.0289C10.3099 20.1304 10.1723 21.5723 10.1145 23.5029C10.0651 25.1511 9.91693 26.8671 9.76276 27.5751C9.57626 28.431 9.51928 29.316 9.5729 30.5218C9.63843 31.9943 9.72305 32.4016 10.1549 33.3201C11.1729 35.4854 12.8405 36.5968 15.5051 36.8857L17.0302 37.0511L17.4023 38.3204C18.3947 41.7052 20.9966 45.353 23.7457 47.2143L24.6121 47.8008L24.6164 50.2387L24.6208 52.6767L21.5626 53.5731C13.4049 55.964 9.70059 57.5859 6.35302 60.233C4.00937 62.0862 2.31774 64.5453 1.47251 67.3273C1.10352 68.5422 1.09045 68.8227 1.03398 76.7293L0.97583 84.8787L1.38889 85.3592L1.80212 85.8394H5.09875H8.39538L8.7999 85.3692C9.34819 84.7318 9.34836 83.7636 8.80023 83.1258C8.40493 82.6658 8.35198 82.6544 6.37045 82.5996L4.34468 82.5438L4.3472 76.1481C4.34988 69.1257 4.41473 68.5114 5.35145 66.623C7.03303 63.2341 10.6207 60.7185 16.8606 58.5538L19.0708 57.787L21.1087 61.7589C22.2294 63.9436 23.3196 65.91 23.5314 66.129C24.1667 66.7859 25.0045 66.6963 26.2675 65.8363C26.8507 65.4391 27.347 65.14 27.3705 65.1712C27.4829 65.3213 28.8459 70.6328 28.8473 70.9256C28.848 71.1099 28.2744 73.7721 27.5726 76.8417C26.8708 79.9114 26.2965 82.4563 26.2965 82.4972C26.2965 82.5383 25.3464 82.5718 24.1851 82.5718H22.0737L21.504 83.1415C20.7303 83.9152 20.7308 84.5803 21.5058 85.3553L22.0774 85.9269L43.8074 85.8832L65.5372 85.8394L65.9504 85.3592L66.3635 84.8787L66.3053 76.7293C66.2488 68.8227 66.2358 68.5422 65.8668 67.3273C65.0216 64.5453 63.3299 62.0862 60.9863 60.233C57.6034 57.5581 53.8327 55.9144 45.5253 53.4937L42.7185 52.6757V50.2143C42.7185 48.3377 42.7708 47.7327 42.9384 47.6685C43.4489 47.4725 45.7463 45.4777 46.4243 44.6415L47.1591 43.7355L50.343 43.6529C52.353 43.6007 53.774 43.4871 54.1971 43.3449C54.5903 43.2127 55.2595 42.7305 55.816 42.1789C57.1491 40.8571 57.2972 40.2776 57.2972 36.3836C57.2972 34.203 57.3696 33.0446 57.5486 32.3572C57.8631 31.1492 57.873 28.8057 57.5685 27.6017C57.4408 27.097 57.2935 25.3345 57.2397 23.6705C57.1729 21.6018 57.0344 20.1436 56.7992 19.0289C54.8309 9.70728 47.7073 2.58432 38.395 0.626254C36.8056 0.292117 32.7716 0.0685769 31.2399 0.229781ZM37.6914 3.88501C40.2964 4.44554 42.9923 5.59072 45.1421 7.0501C46.5597 8.01246 48.8013 10.2038 49.9644 11.7642C51.2398 13.4753 52.6503 16.3718 53.1796 18.3669C53.5838 19.8901 54.0636 23.1897 53.904 23.3493C53.8603 23.3928 53.6353 23.3565 53.4038 23.2685C53.1723 23.1805 52.4542 23.0563 51.8081 22.9927L50.6332 22.8769L50.5216 21.8909C50.3319 20.2138 49.7754 18.3803 48.926 16.6325C46.665 11.9804 42.6295 8.73235 37.5238 7.45562C35.5049 6.95073 31.8379 6.95023 29.8155 7.45462C27.8471 7.94543 25.8803 8.80809 24.2379 9.90099C22.6978 10.9257 20.5229 13.0942 19.5352 14.5895C18.1254 16.7245 17.0868 19.512 16.8189 21.881L16.7061 22.8769L15.5312 22.9927C14.8851 23.0563 14.167 23.1805 13.9355 23.2685C13.704 23.3565 13.479 23.3928 13.4353 23.3493C13.2757 23.1897 13.7555 19.8901 14.1597 18.3669C14.689 16.3718 16.0995 13.4753 17.3749 11.7642C20.772 7.20644 25.4359 4.4871 31.4074 3.58255C32.4271 3.42805 36.4731 3.62276 37.6914 3.88501ZM36.9271 10.7657C40.3598 11.6813 43.0868 13.606 44.9645 16.4383C46.4047 18.6105 47.3297 21.3684 47.2114 23.1366L47.1591 23.9175L45.4859 22.9189C43.4846 21.7248 41.8961 21.1085 40.2974 20.9057C38.3417 20.6577 37.0321 20.9397 32.9156 22.4948C27.2175 24.6476 25.3538 25.1287 21.814 25.3606L20.0964 25.4732L20.0976 23.8178C20.1016 18.1416 23.7226 13.0676 29.1372 11.1512C31.4592 10.3293 34.6915 10.1693 36.9271 10.7657ZM41.4993 24.624C42.263 24.9068 44.174 25.9972 46.5307 27.4951L47.2429 27.9477V31.5696C47.2429 35.6746 46.9989 37.1937 46.0217 39.1708L45.4834 40.26L39.1621 40.3438C33.0609 40.4248 32.8288 40.4397 32.4958 40.7728C32.0045 41.2643 31.8792 42.2384 32.2369 42.7843C32.7835 43.6187 33.2737 43.6948 38.1468 43.7013L42.6347 43.7073L42.132 44.1286C41.1886 44.9192 39.4028 45.8682 37.834 46.4123C36.3285 46.9346 36.1651 46.9559 33.6697 46.9559C31.1697 46.9559 31.0126 46.9352 29.4804 46.4062C24.8594 44.8108 21.5316 41.2095 20.4292 36.6113C20.1601 35.4888 20.0986 34.6372 20.0976 32.0232L20.0964 28.8136L21.8978 28.7025C25.777 28.463 28.3429 27.8232 33.8111 25.7316C35.5305 25.0741 37.352 24.4403 37.8589 24.3233C38.9616 24.0691 40.2986 24.1796 41.4993 24.624ZM16.7066 29.8587C16.7324 31.8579 16.6851 33.4327 16.5965 33.5213C16.3508 33.767 14.7924 33.4798 14.2068 33.081C13.1237 32.3435 12.9746 31.9651 12.9746 29.9544C12.9746 28.3789 13.0209 28.0738 13.3201 27.6729C14.0201 26.7355 15.0225 26.2588 16.1585 26.3231L16.6612 26.3516L16.7066 29.8587ZM52.9465 26.69C54.1423 27.3083 54.5648 28.4553 54.4074 30.6557C54.3149 31.9472 54.041 32.4625 53.1096 33.0964C52.691 33.3812 52.3161 33.4734 51.575 33.4734H50.5943V29.9824C50.5943 28.0622 50.6508 26.4341 50.72 26.3642C50.896 26.1862 52.3972 26.4059 52.9465 26.69ZM53.9458 37.9047C53.9458 39.1584 53.8997 39.3733 53.5418 39.7898C53.1481 40.248 53.087 40.2616 51.172 40.317C49.317 40.3706 49.2137 40.3566 49.3362 40.0657C49.4076 39.8961 49.6704 39.1164 49.9202 38.333L50.3745 36.9086L51.8965 36.823C52.7337 36.7761 53.4744 36.6817 53.5426 36.6135C53.8553 36.3008 53.9458 36.5904 53.9458 37.9047ZM29.5362 49.9314C30.6899 50.2444 31.3386 50.3028 33.6697 50.3028C36.0007 50.3028 36.6494 50.2444 37.8031 49.9314C38.5557 49.7273 39.2156 49.5603 39.2694 49.5603C39.323 49.5603 39.3639 50.3333 39.36 51.2779L39.353 52.9955L36.5194 54.9024L33.6857 56.8094L30.8355 54.9024L27.9855 52.9955L27.9789 51.2779C27.9752 50.3333 28.0163 49.5603 28.0699 49.5603C28.1237 49.5603 28.7836 49.7273 29.5362 49.9314ZM28.4104 57.2876C29.6536 58.1277 30.6482 58.8335 30.6202 58.8559C30.1515 59.235 25.2546 62.4812 25.2157 62.4388C25.0699 62.2798 22.4295 56.8905 22.4751 56.8449C22.5391 56.7807 25.8228 55.7833 26.0138 55.7699C26.0887 55.7647 27.1672 56.4476 28.4104 57.2876ZM43.1188 56.281C44.0507 56.5674 44.8364 56.8233 44.8651 56.8496C44.9098 56.891 42.2666 62.2824 42.1261 62.4363C42.0975 62.4676 40.8647 61.6678 39.3867 60.659L36.6992 58.8246L38.9128 57.2999C40.1304 56.4612 41.1936 55.7718 41.2755 55.7678C41.3575 55.7637 42.187 55.9947 43.1188 56.281ZM54.2769 60.0603C58.254 61.9131 60.6206 63.9278 61.9691 66.609C62.9269 68.5134 62.9894 69.0966 62.9921 76.1622L62.9946 82.5718H52.0187C45.982 82.5718 41.0428 82.5301 41.0428 82.479C41.0428 82.4279 40.4682 79.8828 39.7659 76.8234C39.0636 73.7639 38.49 71.1099 38.4912 70.9256C38.4932 70.6322 39.8572 65.3202 39.9688 65.1712C39.9923 65.14 40.4886 65.4391 41.0718 65.8363C42.3348 66.6963 43.1726 66.7859 43.8079 66.129C44.0197 65.91 45.1099 63.9436 46.2306 61.7589L48.2685 57.787L50.4787 58.5538C51.6945 58.9756 53.4035 59.6534 54.2769 60.0603ZM35.3395 61.9565C36.1586 62.5073 36.8662 63.0187 36.9122 63.0928C36.9579 63.167 36.6434 64.5637 36.2132 66.1969L35.4308 69.1661H33.6702H31.9093L31.1834 66.428C30.7841 64.922 30.4451 63.5545 30.4298 63.3889C30.4111 63.1855 30.8903 62.7448 31.9102 62.0274C32.7396 61.4441 33.5155 60.964 33.6341 60.961C33.7529 60.9578 34.5202 61.4057 35.3395 61.9565ZM35.3497 72.5594C35.3521 72.5824 35.8647 74.8258 36.4887 77.5447L37.6233 82.488L35.6465 82.5351C34.5593 82.5609 32.78 82.5609 31.6928 82.5351L29.716 82.488L30.8506 77.5447C31.4746 74.8258 31.9872 72.5824 31.9896 72.5594C31.9919 72.5365 32.748 72.5175 33.6697 72.5175C34.5913 72.5175 35.3474 72.5365 35.3497 72.5594ZM47.095 74.4665C46.8803 74.6169 46.5986 74.9939 46.4689 75.3044C46.2662 75.7899 46.2662 75.948 46.4689 76.4335C46.9304 77.5381 46.9639 77.5447 52.221 77.5447H56.9567L57.5001 77.059C57.9499 76.6572 58.0437 76.4521 58.0437 75.8689C58.0437 75.2858 57.9499 75.0807 57.5001 74.6789L56.9567 74.1932H52.221C48.1138 74.1932 47.4333 74.2294 47.095 74.4665ZM14.0285 83.0574C13.5787 83.4592 13.4849 83.6644 13.4849 84.2475C13.4849 84.8307 13.5787 85.0358 14.0285 85.4376C14.6347 85.9794 15.1817 86.0469 15.9105 85.6702C16.5008 85.3649 16.745 84.9486 16.745 84.2475C16.745 83.5464 16.5008 83.1301 15.9105 82.8248C15.1817 82.4481 14.6347 82.5157 14.0285 83.0574Z" fill="#353535"/>
                                        <path d="M35.3395 61.9565C36.1586 62.5073 36.8662 63.0187 36.9122 63.0928C36.9579 63.167 36.6434 64.5637 36.2132 66.1969L35.4308 69.1661H33.6702H31.9093L31.1834 66.428C30.7841 64.922 30.4451 63.5545 30.4298 63.3889C30.4111 63.1855 30.8903 62.7448 31.9102 62.0274C32.7396 61.4441 33.5155 60.964 33.6341 60.961C33.7529 60.9578 34.5202 61.4057 35.3395 61.9565Z" fill="#0094E8"/>
                                        <path d="M35.3497 72.5594C35.3521 72.5824 35.8647 74.8258 36.4887 77.5447L37.6233 82.488L35.6465 82.5351C34.5593 82.5609 32.78 82.5609 31.6928 82.5351L29.716 82.488L30.8506 77.5447C31.4746 74.8258 31.9872 72.5824 31.9896 72.5594C31.9919 72.5365 32.748 72.5175 33.6697 72.5175C34.5913 72.5175 35.3474 72.5365 35.3497 72.5594Z" fill="#0094E8"/>
                                    </svg>                                       
                                    <span><?php _e( 'Consulting', 'fintax' ); ?></span>
                                </div>
                                     <?php the_field('service_2_descrription'); ?>
                                
                                <div class="d_flex details_block">
                                    <div class="gray_blue_line"></div>
                                    <div class="d_flex details">
                                        <span><?php _e( 'Learn more', 'fintax' ); ?>  </span>
                                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M0.592773 10.6968C0.592773 16.4835 5.28125 21.172 11.0679 21.172C16.8546 21.172 21.5431 16.4835 21.5431 10.6968C21.5431 4.91015 16.8546 0.22168 11.0679 0.22168C5.28125 0.22168 0.592773 4.91015 0.592773 10.6968ZM19.5156 10.6968C19.5156 15.3853 15.7142 19.1445 11.0679 19.1445C6.37945 19.1445 2.62022 15.3853 2.62022 10.6968C2.62022 6.05059 6.37945 2.24913 11.0679 2.24913C15.7142 2.24913 19.5156 6.05059 19.5156 10.6968ZM14.9539 11.077C15.1651 10.8658 15.1651 10.5701 14.9539 10.3589L9.75853 5.16359C9.58958 4.95239 9.25167 4.95239 9.04047 5.16359L8.11123 6.13507C7.90004 6.30402 7.90004 6.64193 8.11123 6.85313L11.9549 10.6968L8.11123 14.5828C7.90004 14.794 7.90004 15.0896 8.11123 15.3008L9.04047 16.2723C9.25167 16.4413 9.58958 16.4413 9.75853 16.2723L14.9539 11.077Z" fill="#282828"/>
                                        </svg>                                        
                                    </div>
                                </div>
                            </div>
                        </a>
                        <a href="<?php the_field('but_3'); ?>" class="d_flex for_service_product">
                            <div class="service_products">
                                <div class="d_flex svg_title">
                                    <svg width="86" height="87" viewBox="0 0 86 87" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M22.3695 0.975277C19.2988 1.71929 16.7619 4.25112 16.0467 7.28534C15.9075 7.87586 15.7925 8.71539 15.7912 9.15107C15.789 9.8346 15.7255 9.98122 15.3278 10.2215C12.6204 11.8573 10.4542 13.8293 9.03336 15.9516C6.70579 19.4282 5.54788 23.5458 5.79655 27.4621C5.85504 28.3837 6.00803 29.5807 6.13656 30.1219C6.34317 30.992 6.33948 31.1768 6.10438 31.7139C5.93664 32.0974 5.83644 32.8161 5.83308 33.6622C5.82856 34.7675 5.90564 35.171 6.27212 35.9613C6.83399 37.1728 7.98151 38.2956 9.15485 38.7818L10.0658 39.1594L10.2581 40.2642C10.9267 44.1037 13.2246 47.6405 16.417 49.7433L17.1292 50.2125L17.1229 52.3268L17.1165 54.441L14.8188 56.1375L12.521 57.834L10.416 57.9198C8.67023 57.991 8.06832 58.0892 6.88962 58.4956C3.56903 59.6403 1.2113 62.1872 0.361382 65.548C0.0398129 66.8194 0.0238937 67.3157 0.0709812 74.5755L0.12075 82.2579L0.583581 83.2004C1.12953 84.3119 2.41128 85.5699 3.5196 86.082L4.31003 86.4471H24.3348H44.3595L45.2812 86.0125C46.4565 85.458 47.5597 84.3548 48.1141 83.1795L48.5488 82.2579L48.5471 74.0469C48.5455 65.951 48.5401 65.822 48.1701 64.846C47.9637 64.3018 47.7948 63.7927 47.7948 63.7149C47.7948 63.6373 48.2443 63.5737 48.7938 63.5737C50.8482 63.5737 52.8522 62.3068 53.777 60.4238C54.2045 59.553 54.2462 59.3046 54.2462 57.6249V55.7816L52.0259 51.9513C50.8048 49.8446 49.8056 48.0913 49.8056 48.0552C49.8056 48.019 51.54 47.9895 53.6597 47.9895C56.7238 47.9895 57.5139 48.0345 57.5139 48.2089C57.5139 48.3295 57.7778 48.8664 58.1004 49.4022L58.6869 50.3761V61.3927V72.4094L57.8909 72.7122C57.3854 72.9044 56.7226 73.3866 56.0746 74.0336C55.0028 75.1037 54.6109 75.9163 54.3932 77.5198C54.3138 78.1048 54.1992 78.3389 53.9542 78.4166C53.4168 78.5872 52.3219 79.6687 51.9512 80.3951C51.52 81.2404 51.3446 83.5145 51.6413 84.4135C51.9105 85.2286 52.5918 86.0191 53.2695 86.3023C53.9716 86.5956 71.7784 86.6417 72.5425 86.3521C74.1718 85.7348 74.8905 83.4216 74.188 81.056C73.902 80.0928 72.8572 78.8042 72.112 78.4956C71.6815 78.3173 71.6026 78.1783 71.5039 77.4256C71.2365 75.3868 69.733 73.3642 67.9899 72.6984L67.233 72.4094V61.3689V50.3283L67.6462 49.7036C67.8735 49.3599 68.1448 48.8336 68.2492 48.5342L68.4389 47.9895H72.2766C74.3873 47.9895 76.1143 48.0192 76.1143 48.0556C76.1143 48.0918 75.0963 49.9 73.8521 52.0736L71.5899 56.0256V57.5311C71.5899 60.0703 72.5871 61.8609 74.6316 62.9935C75.5114 63.4808 75.5801 63.4909 78.3768 63.545C81.78 63.6109 82.5817 63.4036 83.9702 62.0992C85.1933 60.9502 85.7151 59.7117 85.8036 57.7484L85.8736 56.1963L83.5913 52.1958C82.336 49.9955 81.309 48.1575 81.309 48.111C81.309 48.0646 82.1462 47.9979 83.1695 47.9629C84.9619 47.9016 85.045 47.8821 85.4317 47.4324C85.9574 46.8212 85.9537 46.0838 85.422 45.5522L85.0108 45.1408H76.7901H68.5694L68.1671 44.2313C67.6312 43.0194 66.6232 41.9588 65.4383 41.3601C64.5797 40.9261 64.2945 40.8696 62.9599 40.8696C61.6254 40.8696 61.3402 40.9261 60.4816 41.3601C59.3059 41.9541 58.2974 43.0098 57.7379 44.2318L57.3217 45.1408H49.1154H40.9091L40.4979 45.5522C39.9653 46.0846 39.9625 46.8211 40.4905 47.4356C40.8813 47.8903 40.9558 47.9076 42.7527 47.9624C43.7747 47.9937 44.6109 48.0588 44.6109 48.1073C44.6109 48.1558 43.5929 49.9798 42.3487 52.1606C40.1867 55.9502 40.0865 56.1674 40.0865 57.0627V57.9996L38.1175 57.9173L36.1486 57.8352L33.8508 56.138L31.5531 54.441L31.5539 52.3464L31.5549 50.2518L32.742 49.4141C35.6234 47.3806 37.8603 43.8613 38.4473 40.4375L38.6529 39.2386L39.4955 38.8588C40.7373 38.2989 41.6761 37.3974 42.2671 36.1967C42.9483 34.8131 43.0758 33.5793 42.6865 32.1407C42.4338 31.2076 42.4192 30.9047 42.5873 30.0918C43.3695 26.3075 42.7634 21.8163 40.9867 18.2309C39.4888 15.2083 37.3668 12.8376 34.4309 10.9072L32.8809 9.88805V9.0331C32.8809 7.05861 31.8855 4.7706 30.3652 3.25022C28.3002 1.18524 25.1738 0.295776 22.3695 0.975277ZM26.7679 4.16399C28.2898 4.90867 29.6012 6.59578 29.9503 8.25842C30.0575 8.76918 30.0376 8.81526 29.7577 8.70265C29.5861 8.63361 28.7293 8.42616 27.8538 8.24183C25.3975 7.72471 20.858 7.95813 18.9313 8.70047C18.6774 8.79834 18.6526 8.73868 18.7444 8.25088C19.1369 6.1663 20.9088 4.31866 23.078 3.73233C23.9889 3.48616 25.8203 3.70032 26.7679 4.16399ZM27.2106 11.0259C32.1575 11.9798 36.2102 15.0767 38.4129 19.5862C39.5796 21.9745 39.9673 23.6115 39.9868 26.2324C39.9955 27.3996 39.9534 28.404 39.8933 28.4645C39.8331 28.5252 39.4884 28.4239 39.1275 28.2398C38.6197 27.9809 38.4257 27.754 38.2713 27.2387C38.1616 26.8722 37.7274 26.1894 37.3065 25.7212C36.2193 24.512 34.7282 23.8271 31.419 23.0173C27.1046 21.9614 26.5534 21.6727 25.8471 20.0983C25.0537 18.3298 24.1528 17.8505 22.0114 18.057C16.2084 18.6168 11.2642 22.4145 10.2454 27.0949C10.0552 27.9688 9.97394 28.0932 9.45011 28.312C9.12938 28.4461 8.82188 28.5106 8.76675 28.4554C8.71179 28.4003 8.67325 27.4379 8.68112 26.3167C8.71112 22.0633 10.3134 18.2348 13.2947 15.2941C15.6747 12.9464 18.1797 11.6913 22.0726 10.8962C22.89 10.7291 26.0911 10.81 27.2106 11.0259ZM23.4041 21.6371C23.8646 22.7567 24.8263 23.7252 26.0991 24.3518C26.7148 24.6549 28.4904 25.2188 30.1624 25.6423C34.4621 26.731 35.1341 27.0837 35.6716 28.5347C36.1486 29.8218 36.5345 30.231 37.8271 30.82C38.4902 31.1223 39.1945 31.5751 39.3921 31.8263C39.88 32.4467 40.152 33.4286 40.0238 34.1069C39.8187 35.1928 39.3227 35.7421 38.0052 36.3425C36.3634 37.0907 35.9584 37.6296 35.6581 39.4657C34.2059 48.3408 24.3368 52.3122 17.2583 46.87C14.8447 45.0145 13.4805 42.4401 12.8592 38.5685C12.7137 37.6633 12.0558 36.992 10.6687 36.3338C9.35057 35.7083 8.81267 35.0958 8.63856 34.0223C8.41955 32.6737 9.17127 31.5816 10.8425 30.82C12.305 30.1536 12.6817 29.6744 13.0247 28.0434C13.4943 25.812 14.744 24.0207 16.7081 22.7642C18.2282 21.792 20.9264 20.9037 22.4915 20.8604C23.0381 20.8454 23.1001 20.8981 23.4041 21.6371ZM64.2218 44.0097C65.2548 44.5317 65.7249 45.2886 65.7249 46.4308C65.7249 47.5239 65.4253 48.1528 64.607 48.7768C64.0844 49.1754 63.8333 49.2463 62.9434 49.2463C62.1462 49.2463 61.7846 49.1636 61.4325 48.9008C59.9804 47.8166 59.6947 45.9603 60.7813 44.669C61.668 43.6153 62.9534 43.3689 64.2218 44.0097ZM48.9461 52.3883L50.4566 55.0275H47.2823C45.5366 55.0275 44.1082 54.9799 44.1082 54.922C44.1082 54.614 47.1858 49.4925 47.3003 49.61C47.3747 49.6865 48.1153 50.9366 48.9461 52.3883ZM80.3733 52.3206C81.1774 53.7349 81.8032 54.9243 81.7639 54.9637C81.7246 55.0029 80.2967 55.0146 78.5907 54.9895L75.4889 54.9438L76.9327 52.4295C78.716 49.3241 78.6403 49.4394 78.7884 49.6088C78.8559 49.6859 79.5691 50.9063 80.3733 52.3206ZM24.3348 52.0756C26.5184 52.0828 27.3804 51.9759 28.4508 51.5652C28.6486 51.4893 28.6916 51.7274 28.6916 52.897V54.3212L26.5226 55.9421L24.3536 57.5631L22.1657 55.9307L19.9779 54.2983V53.0152C19.9779 52.3094 20.0168 51.693 20.0644 51.6454C20.112 51.5979 20.5455 51.6734 21.0279 51.8134C21.625 51.9865 22.6809 52.0702 24.3348 52.0756ZM64.3843 62.1912V72.2874H62.9599H61.5356V62.1912V52.095H62.9599H64.3843V62.1912ZM20.4485 58.2114C21.3813 58.9026 22.1448 59.5059 22.145 59.552C22.1453 59.598 21.3552 60.4652 20.3893 61.479L18.633 63.3223L16.8774 61.479C15.9118 60.4652 15.1242 59.598 15.1273 59.552C15.1355 59.4258 18.5383 56.8899 18.653 56.9246C18.7077 56.941 19.5156 57.5202 20.4485 58.2114ZM32.3363 58.5554C33.0046 59.0528 33.5512 59.5039 33.5512 59.5583C33.5512 59.6126 32.7638 60.4816 31.8013 61.4897L30.0513 63.3223L28.2905 61.479C27.3221 60.4652 26.5295 59.598 26.5291 59.552C26.5288 59.5059 27.3284 58.8837 28.3064 58.1695L30.0843 56.8708L30.6028 57.2611C30.888 57.4758 31.668 58.0582 32.3363 58.5554ZM51.4238 58.5008C51.3019 59.252 50.8935 59.8368 50.1255 60.3593C49.5826 60.7286 49.4351 60.7452 47.1246 60.6945C44.873 60.645 44.6533 60.6117 44.1305 60.2388C43.577 59.844 42.9461 58.7485 42.9389 58.1695C42.9355 57.8977 43.2501 57.8763 47.2302 57.8763H51.5252L51.4238 58.5008ZM82.981 58.1695C82.9738 58.7485 82.3429 59.844 81.7894 60.2388C81.2666 60.6117 81.0469 60.645 78.7953 60.6945C76.4848 60.7452 76.3373 60.7286 75.7944 60.3593C75.0264 59.8368 74.618 59.252 74.496 58.5008L74.3947 57.8763H78.6897C82.6698 57.8763 82.9844 57.8977 82.981 58.1695ZM10.5939 60.8548C10.5939 60.9262 9.53674 63.2786 8.2446 66.0824C6.95263 68.8862 5.85118 71.4569 5.79706 71.795C5.72902 72.2203 5.80057 72.6363 6.02931 73.1445C6.21112 73.5487 7.95387 76.0661 9.90222 78.7389L13.4445 83.5984L9.54763 83.6472C7.40423 83.6742 5.40393 83.6516 5.10247 83.5971C4.4213 83.4741 3.41285 82.6086 3.11206 81.8889C2.75748 81.0401 2.7863 67.5444 3.14574 66.1643C3.96416 63.0212 6.67747 60.9421 10.2169 60.7459C10.4242 60.7343 10.5939 60.7834 10.5939 60.8548ZM40.4312 61.0712C40.7596 61.1549 41.3709 61.5524 41.7922 61.9561C42.213 62.3593 42.9332 62.8591 43.3927 63.0668C44.3483 63.4986 45.067 64.5154 45.5198 66.0758C45.8834 67.3291 45.9161 81.0304 45.5575 81.8889C45.2567 82.6086 44.2483 83.4741 43.5671 83.5971C43.2656 83.6516 41.273 83.6742 39.1392 83.6472L35.2594 83.5984L39.0097 78.4255C42.7874 73.2147 43.09 72.6847 42.8814 71.6417C42.8301 71.3853 41.7278 68.8662 40.432 66.0437C39.136 63.2211 38.0756 60.8625 38.0756 60.8025C38.0756 60.6777 39.5447 60.8453 40.4312 61.0712ZM22.9942 72.2874C22.9942 77.3564 22.9312 81.5038 22.8543 81.5038C22.7774 81.5038 22.2227 80.8441 21.622 80.0375C19.0883 76.637 16.9756 72.4332 15.8701 68.5928C15.2875 66.5685 14.7001 63.7686 14.8307 63.638C14.871 63.5976 15.3794 64.0757 15.9606 64.7002C17.3553 66.199 17.7075 66.4199 18.7051 66.4212C19.5218 66.4224 19.5374 66.412 21.2186 64.7488C22.1492 63.8282 22.9294 63.0741 22.9523 63.0731C22.9753 63.072 22.9942 67.2183 22.9942 72.2874ZM29.5498 66.4093C30.5706 66.6374 31.3068 66.2555 32.6609 64.7949C33.4944 63.8959 33.8733 63.5859 33.8786 63.7987C33.8967 64.5231 33.144 67.6756 32.4669 69.711C31.0497 73.9706 28.9675 77.7473 26.0578 81.3359C25.8967 81.5344 25.8525 79.6359 25.8483 72.3397L25.8429 63.0917L27.393 64.6827C28.5691 65.89 29.0893 66.3064 29.5498 66.4093ZM13.568 70.8525C14.887 74.844 17.394 79.4403 19.9947 82.6349L20.8473 83.6822H18.943H17.0387L12.8245 77.8963L8.61007 72.1102L9.87038 69.3921C10.5634 67.897 11.3192 66.259 11.5499 65.7521L11.9694 64.8305L12.3829 66.6737C12.6103 67.6875 13.1435 69.568 13.568 70.8525ZM38.4108 68.3872C39.2863 70.2921 39.994 71.9385 39.9833 72.0461C39.9725 72.1535 38.0959 74.8157 35.8129 77.9618L31.662 83.6822H29.7559H27.8498L28.8724 82.3953C32.5736 77.7378 35.2844 71.9465 36.3394 66.4432C36.5006 65.6023 36.6744 64.9164 36.7257 64.9191C36.7769 64.9216 37.5352 66.4824 38.4108 68.3872ZM67.0319 75.3715C67.2808 75.501 67.6605 75.7955 67.8756 76.0259C68.282 76.4611 68.7678 77.6386 68.6317 77.8586C68.5888 77.928 65.9893 77.9848 62.855 77.9848C57.2362 77.9848 57.1575 77.9801 57.2513 77.6497C57.3036 77.4653 57.3927 77.1449 57.4494 76.9375C57.5791 76.4626 58.1198 75.8538 58.7707 75.4496C59.2209 75.1699 59.6549 75.1373 62.9264 75.1367C65.7383 75.1362 66.6835 75.1904 67.0319 75.3715ZM71.0235 81.2271C71.4074 81.5576 71.493 81.7865 71.5555 82.6515L71.6301 83.6822H62.9599H54.2898L54.3644 82.6515C54.4269 81.7865 54.5125 81.5576 54.8964 81.2271L55.3542 80.8335H62.9599H70.5657L71.0235 81.2271Z" fill="#282828"/>
                                        <path d="M29.5498 66.4093C30.5706 66.6374 31.3068 66.2555 32.6609 64.7949C33.4944 63.8959 33.8733 63.5859 33.8786 63.7987C33.8967 64.5231 33.144 67.6756 32.4669 69.711C31.0497 73.9706 28.9675 77.7473 26.0578 81.3359C25.8967 81.5344 25.8525 79.6359 25.8483 72.3397L25.8429 63.0917L27.393 64.6827C28.5691 65.89 29.0893 66.3064 29.5498 66.4093Z" fill="#238DC1"/>
                                        <path d="M22.9942 72.2874C22.9942 77.3564 22.9312 81.5038 22.8543 81.5038C22.7774 81.5038 22.2227 80.8441 21.622 80.0375C19.0883 76.637 16.9756 72.4332 15.8701 68.5928C15.2875 66.5685 14.7001 63.7686 14.8307 63.638C14.871 63.5976 15.3794 64.0757 15.9606 64.7002C17.3553 66.199 17.7075 66.4199 18.7051 66.4212C19.5218 66.4224 19.5374 66.412 21.2186 64.7488C22.1492 63.8282 22.9294 63.0741 22.9523 63.0731C22.9753 63.072 22.9942 67.2183 22.9942 72.2874Z" fill="#238DC1"/>
                                        <path d="M82.981 58.1695C82.9738 58.7485 82.3429 59.844 81.7894 60.2388C81.2666 60.6117 81.0469 60.645 78.7953 60.6945C76.4848 60.7452 76.3373 60.7286 75.7944 60.3593C75.0264 59.8368 74.618 59.252 74.496 58.5008L74.3947 57.8763H78.6897C82.6698 57.8763 82.9844 57.8977 82.981 58.1695Z" fill="white"/>
                                        <path d="M51.4238 58.5008C51.3019 59.252 50.8935 59.8368 50.1255 60.3593C49.5826 60.7286 49.4351 60.7452 47.1246 60.6945C44.873 60.645 44.6533 60.6117 44.1305 60.2388C43.577 59.844 42.9461 58.7485 42.9389 58.1695C42.9355 57.8977 43.2501 57.8763 47.2302 57.8763H51.5252L51.4238 58.5008Z" fill="white"/>
                                        </svg>                                                                             
                                    <span><?php _e( 'Protection of interests', 'fintax' ); ?></span>
                                </div>
                                
                                      <?php the_field('service_3_descrription'); ?>
                                
                                <div class="d_flex details_block">
                                    <div class="gray_blue_line"></div>
                                    <div class="d_flex details">
                                        <span> <?php _e( 'Learn more', 'fintax' ); ?></span>
                                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M0.592773 10.6968C0.592773 16.4835 5.28125 21.172 11.0679 21.172C16.8546 21.172 21.5431 16.4835 21.5431 10.6968C21.5431 4.91015 16.8546 0.22168 11.0679 0.22168C5.28125 0.22168 0.592773 4.91015 0.592773 10.6968ZM19.5156 10.6968C19.5156 15.3853 15.7142 19.1445 11.0679 19.1445C6.37945 19.1445 2.62022 15.3853 2.62022 10.6968C2.62022 6.05059 6.37945 2.24913 11.0679 2.24913C15.7142 2.24913 19.5156 6.05059 19.5156 10.6968ZM14.9539 11.077C15.1651 10.8658 15.1651 10.5701 14.9539 10.3589L9.75853 5.16359C9.58958 4.95239 9.25167 4.95239 9.04047 5.16359L8.11123 6.13507C7.90004 6.30402 7.90004 6.64193 8.11123 6.85313L11.9549 10.6968L8.11123 14.5828C7.90004 14.794 7.90004 15.0896 8.11123 15.3008L9.04047 16.2723C9.25167 16.4413 9.58958 16.4413 9.75853 16.2723L14.9539 11.077Z" fill="#282828"/>
                                        </svg>                                        
                                    </div>
                                </div>
                            </div>
                        </a>
                        <a href="<?php the_field('but_4'); ?>" class="d_flex for_service_product">
                            <div class="service_products">
                                <div class="d_flex svg_title">
                                    <svg width="87" height="65" viewBox="0 0 87 65" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M39.9239 1.32221C37.3755 1.94791 34.7911 3.59797 33.2508 5.58283C32.4597 6.60232 31.3998 8.74956 31.0204 10.1013C30.6687 11.3549 30.4915 19.7038 30.7687 21.9691C31.1521 25.1028 32.3539 27.5395 34.6287 29.7953C37.1935 32.3385 40.0504 33.4917 43.7779 33.488C45.8489 33.486 47.6043 33.0696 49.5285 32.124C52.2341 30.7943 53.1646 29.272 51.7266 28.5283C51.1736 28.2424 50.75 28.3599 49.672 29.0982C47.7637 30.4052 45.9631 30.9698 43.6941 30.9721C42.8024 30.9731 41.6599 30.8605 41.0967 30.7161C37.6071 29.8209 34.7381 27.0683 33.6015 23.5248C33.3391 22.7064 33.2555 21.8388 33.1839 19.192C33.1346 17.3717 33.1504 15.8825 33.2189 15.8825C33.2875 15.8825 33.8517 16.2203 34.4729 16.6334C36.0113 17.6561 38.0228 18.5889 38.9042 18.6881C39.5003 18.7553 39.7009 18.7027 40.004 18.3996C40.4725 17.931 40.4112 17.3514 39.6782 15.3231C39.384 14.5088 39.1695 13.816 39.2015 13.784C39.2337 13.7518 39.7863 14.0667 40.4296 14.4838C43.0094 16.1558 48.2503 18.5495 52.0362 19.7847L54.1275 20.467L54.0256 21.673C53.9695 22.3363 53.7334 23.4064 53.5008 24.051C53.2682 24.6956 53.078 25.387 53.078 25.5875C53.078 26.0866 53.8063 26.7745 54.3348 26.7745C55.0146 26.7745 55.4858 26.1414 56.0199 24.5105L56.5132 23.0042V16.8879C56.5132 11.4461 56.4795 10.6627 56.208 9.78346C55.4624 7.36828 54.124 5.31907 52.277 3.76487C51.0186 2.70583 48.6362 1.55932 47.0106 1.23021C45.1474 0.85301 41.6497 0.898422 39.9239 1.32221ZM47.7458 4.0184C49.2874 4.59568 50.3729 5.32963 51.5558 6.59395C52.6594 7.7738 53.5985 9.53479 53.8996 10.9893C54.1126 12.0185 54.151 17.7258 53.9448 17.7258C53.3151 17.7258 47.4029 15.4001 45.137 14.2609C43.04 13.2069 40.7716 11.7574 39.6622 10.7624C38.4478 9.67354 37.9915 9.49407 37.3329 9.84647C37.1644 9.93662 36.9432 10.2495 36.8413 10.5417C36.6221 11.1704 36.6025 13.69 36.8098 14.5827C36.916 15.0403 36.9036 15.1795 36.7639 15.0981C35.9756 14.638 34.4469 13.5281 33.8731 12.9993C33.1876 12.3672 33.1822 12.3535 33.3282 11.5664C34.0283 7.79039 36.5283 4.96986 40.1496 3.8701C41.3049 3.51921 41.6891 3.48653 44.0292 3.53999C46.3013 3.59194 46.7666 3.65176 47.7458 4.0184ZM11.1018 5.67181C10.2057 5.93908 9.8965 6.85703 10.4409 7.63422L10.7017 8.00672H18.1492H25.5965V9.4247C25.5965 11.4153 25.1814 12.4579 23.8543 13.8011C23.1092 14.5552 22.5586 14.9429 21.8262 15.2295C20.838 15.6162 20.7009 15.6239 13.8247 15.6804L6.82862 15.7379V14.4163C6.82862 12.8491 7.12505 11.7469 7.85398 10.6041C8.1479 10.1432 8.38937 9.55976 8.39054 9.30757C8.39356 8.6517 7.89705 8.17429 7.21219 8.17429C6.51007 8.17429 5.84347 8.84206 5.20486 10.1851C4.36601 11.9495 4.31926 12.3836 4.31708 18.4111C4.3149 24.7134 4.43002 25.5947 5.52576 27.665C6.73193 29.9438 9.4464 32.0595 12.0137 32.7219C13.3769 33.0736 15.8007 33.0731 17.1342 32.7209C20.6884 31.7818 23.5696 28.8851 24.4925 25.3232C24.699 24.5266 24.7586 23.4122 24.7586 20.3522V16.408L25.2607 16.0506C25.9335 15.5715 27.1653 13.8202 27.5933 12.7342C27.9602 11.8033 28.2962 9.40777 28.2635 7.95511C28.2362 6.74023 27.9874 5.86418 27.6127 5.6636C27.2125 5.44944 11.8219 5.45715 11.1018 5.67181ZM69.6592 7.65298C68.0134 8.09721 66.8732 8.78441 65.4638 10.1818C64.112 11.5218 63.3321 12.8386 62.8767 14.5495C62.5131 15.9158 62.5271 23.901 62.8956 25.3232C63.8186 28.8851 66.6998 31.7818 70.254 32.7209C71.5875 33.0731 74.0112 33.0736 75.3744 32.7219C77.9417 32.0595 80.6562 29.9438 81.8624 27.665C82.8948 25.7146 83.0731 24.5646 83.0731 19.8596C83.0731 16.7036 83.0121 15.444 82.8239 14.7182C81.8892 11.1108 79.3158 8.52468 75.7382 7.59769C74.3329 7.23356 71.1039 7.26288 69.6592 7.65298ZM75.3848 10.0884C77.8241 10.8289 79.5149 12.5033 80.2427 14.8995C80.4292 15.5135 80.5579 16.2912 80.5287 16.6278L80.4757 17.2396L79.3865 16.5848C78.5933 16.1079 78.1125 15.6616 77.6173 14.9426C77.0553 14.127 76.8431 13.9462 76.3961 13.9025C75.9438 13.8583 75.702 13.9893 74.9221 14.7021C73.9041 15.6325 71.8546 16.7026 70.254 17.1396C69.701 17.2906 68.3249 17.4566 67.1958 17.5088L65.1431 17.6034V16.6052C65.1431 13.7311 67.256 11.0355 70.254 10.0849C71.1779 9.79201 74.4151 9.79419 75.3848 10.0884ZM76.7626 17.8235C77.1458 18.1537 78.1571 18.7644 79.0095 19.1806L80.5595 19.9373V21.9013C80.5595 24.8262 79.9326 26.589 78.3223 28.1917C76.7456 29.7608 75.0185 30.4786 72.8246 30.4765C69.4303 30.4729 66.5959 28.4311 65.4789 25.1848C65.2144 24.4161 65.1431 23.7735 65.1431 22.1642V20.1198L67.2796 20.0203C70.354 19.8772 72.92 19.135 74.9364 17.806C75.4024 17.4989 75.8471 17.242 75.9247 17.2353C76.0023 17.2286 76.3793 17.4932 76.7626 17.8235ZM21.9785 25.0025C20.4352 29.7929 15.0949 31.9202 10.7173 29.4885C9.65603 28.899 8.2962 27.5168 7.78595 26.5091C6.97658 24.911 6.82862 24.0688 6.82862 21.0607V18.2565L13.9922 18.1847C17.9863 18.1447 21.3782 18.0405 21.6586 17.9491L22.1613 17.7852L22.2069 20.9686C22.2439 23.5493 22.2007 24.3131 21.9785 25.0025ZM8.72099 35.2381C5.47951 35.9426 2.68343 38.4161 1.42951 41.6882L0.883731 43.1125L0.88172 48.8339C0.879877 54.3198 0.893617 54.5708 1.21502 54.9314C1.95434 55.7612 1.99154 55.7641 11.9452 55.7641C18.7068 55.7641 21.362 55.7106 21.6278 55.5692C22.4624 55.1246 22.6293 54.4089 22.0653 53.6921L21.7181 53.2505H12.5138H3.30965L3.31249 48.9356C3.31585 44.0721 3.47236 42.9098 4.32428 41.4206C5.70774 39.0029 8.65011 37.3292 11.1618 37.5315L11.7988 37.5828L10.8091 41.7673C9.92264 45.5148 9.84254 45.9991 10.0416 46.406C10.1638 46.656 11.1075 47.7326 12.1388 48.7987C14.652 51.3969 14.4891 51.4007 17.0926 48.6854C18.1758 47.5558 19.1083 46.4594 19.165 46.249C19.2246 46.0276 18.8714 44.1925 18.3265 41.8921C17.8087 39.7064 17.3852 37.8237 17.3852 37.7084C17.3855 37.4418 18.5594 37.4314 19.7652 37.6875C21.0426 37.9588 22.3416 38.6641 23.5501 39.7426C24.1963 40.3192 24.7561 40.6828 24.9978 40.6828C25.5595 40.6828 26.0804 40.1883 26.2068 39.5353C26.3088 39.0074 26.2441 38.9057 25.1191 37.8244C23.7825 36.54 22.1853 35.6674 20.3993 35.2465C18.9423 34.9032 10.2911 34.8969 8.72099 35.2381ZM66.9136 35.2539C65.3391 35.6348 63.6473 36.5406 62.4335 37.653C61.212 38.7722 60.9865 39.2655 61.363 39.9936C61.8739 40.9819 62.5231 40.916 63.838 39.7426C65.0465 38.6641 66.3456 37.9588 67.6229 37.6875C68.8288 37.4314 70.0026 37.4418 70.0029 37.7084C70.0029 37.8237 69.5795 39.7064 69.0617 41.8921C68.5168 44.1925 68.1635 46.0276 68.2232 46.249C68.2798 46.4594 69.2123 47.5558 70.2955 48.6854C72.899 51.4007 72.7362 51.3969 75.2494 48.7987C76.2806 47.7326 77.2244 46.656 77.3465 46.406C77.5456 45.9991 77.4655 45.5148 76.5791 41.7673L75.5894 37.5828L76.2263 37.5315C78.738 37.3292 81.6804 39.0029 83.0639 41.4206C83.9158 42.9098 84.0723 44.0721 84.0757 48.9356L84.0785 53.2505H74.8744H65.6701L65.3229 53.6921C64.7588 54.4089 64.9257 55.1246 65.7604 55.5692C66.0262 55.7106 68.6813 55.7641 75.4429 55.7641C85.3966 55.7641 85.4338 55.7612 86.1731 54.9314C86.4945 54.5708 86.5083 54.3198 86.5064 48.8339L86.5044 43.1125L85.9586 41.6882C84.6896 38.3765 81.9006 35.9324 78.5899 35.2307C76.9967 34.8931 68.3341 34.9102 66.9136 35.2539ZM35.5669 36.3223C32.6185 37.109 31.095 37.9926 28.9454 40.1625C26.7633 42.3655 25.6843 44.4231 25.1725 47.3576C24.8686 49.101 24.8121 61.3051 25.1045 62.0789C25.347 62.7209 26.07 63.4652 26.7222 63.7442C27.5234 64.0871 59.8648 64.0871 60.6659 63.7442C61.3181 63.4652 62.0412 62.7209 62.2836 62.0789C62.5761 61.3051 62.5196 49.101 62.2156 47.3576C61.7039 44.4231 60.6249 42.3655 58.4428 40.1625C56.2774 37.9767 54.4125 36.9152 51.5699 36.2504C50.6859 36.0438 49.1858 35.997 43.6103 36.0026C37.4459 36.0086 36.6194 36.0414 35.5669 36.3223ZM14.8556 38.1274C14.9457 38.473 15.3779 40.2865 15.8156 42.1572L16.6117 45.5587L15.5743 46.5962L14.5368 47.6336L13.5137 46.6104L12.4907 45.5874L13.3551 41.9201C13.8307 39.9033 14.2615 38.0835 14.3126 37.876C14.4506 37.3163 14.6704 37.418 14.8556 38.1274ZM73.0755 37.876C73.1266 38.0835 73.5574 39.9033 74.033 41.9201L74.8975 45.5874L73.8745 46.6104L72.8513 47.6336L71.8139 46.5962L70.7764 45.5587L71.5726 42.1572C72.6113 37.7185 72.671 37.499 72.8396 37.499C72.9182 37.499 73.0244 37.6685 73.0755 37.876ZM37.8353 39.1328C38.1388 40.0874 38.9649 41.3001 39.7503 41.9438L40.4553 42.5214L40.0643 44.6458C39.8492 45.8143 39.6449 46.7986 39.6104 46.8333C39.5757 46.8678 38.589 45.15 37.4176 43.0159C36.1462 40.6997 35.3487 39.0745 35.4392 38.984C35.582 38.8412 36.7369 38.5632 37.3552 38.5228C37.5392 38.5107 37.7043 38.7206 37.8353 39.1328ZM47.0455 38.6103C47.0455 38.9659 46.2388 39.9108 45.6312 40.2669C44.6308 40.853 44.3062 41.2614 44.3334 41.8988C44.3461 42.1978 44.6899 44.252 45.0976 46.4639L45.8388 50.4856L44.8389 52.3708C44.2891 53.4077 43.7738 54.2559 43.6941 54.2559C43.6143 54.2559 43.099 53.4077 42.5492 52.3708L41.5493 50.4856L42.2905 46.4639C42.6982 44.252 43.0421 42.1978 43.0548 41.8988C43.0819 41.2614 42.7574 40.853 41.757 40.2669C41.1493 39.9108 40.3427 38.9659 40.3427 38.6103C40.3427 38.552 41.8508 38.5044 43.6941 38.5044C45.5373 38.5044 47.0455 38.552 47.0455 38.6103ZM51.6956 38.8583C51.903 38.9355 52.0726 39.0411 52.0726 39.0927C52.0726 39.2693 47.8408 46.8963 47.7778 46.8333C47.7432 46.7986 47.539 45.8143 47.3238 44.6458L46.9329 42.5214L47.6378 41.9438C48.4256 41.2983 49.2495 40.0871 49.5555 39.1249L49.7578 38.4885L50.5381 38.6031C50.9673 38.6661 51.4881 38.7809 51.6956 38.8583ZM38.0501 49.3932C42.0417 56.6775 42.8485 58.045 43.2356 58.1811C44.3315 58.5665 44.2375 58.7029 49.5424 49.0264L54.4725 40.0335L55.1577 40.5115C56.2064 41.243 57.6835 42.8329 58.3528 43.9504C58.6839 44.5034 59.1581 45.5591 59.4065 46.2964L59.8579 47.6369L59.8612 54.5073L59.8646 61.3776H43.6941H27.5235L27.5269 54.5073L27.5302 47.6369L27.9817 46.2964C28.7621 43.9801 30.176 42.0357 32.1317 40.5905L32.8858 40.0331L33.1045 40.3998C33.2248 40.6015 35.4505 44.6485 38.0501 49.3932Z" fill="#353535"/>
                                        <path d="M47.0455 38.6103C47.0455 38.9659 46.2388 39.9108 45.6312 40.2669C44.6308 40.853 44.3062 41.2614 44.3334 41.8988C44.3461 42.1978 44.6899 44.252 45.0976 46.4639L45.8388 50.4856L44.8389 52.3708C44.2891 53.4077 43.7738 54.2559 43.6941 54.2559C43.6143 54.2559 43.099 53.4077 42.5492 52.3708L41.5493 50.4856L42.2905 46.4639C42.6982 44.252 43.0421 42.1978 43.0548 41.8988C43.0819 41.2614 42.7574 40.853 41.757 40.2669C41.1493 39.9108 40.3427 38.9659 40.3427 38.6103C40.3427 38.552 41.8508 38.5044 43.6941 38.5044C45.5373 38.5044 47.0455 38.552 47.0455 38.6103Z" fill="#0094E8"/>
                                        <path d="M73.0755 37.876C73.1266 38.0835 73.5574 39.9033 74.033 41.9201L74.8975 45.5874L73.8745 46.6104L72.8513 47.6336L71.8139 46.5962L70.7764 45.5587L71.5726 42.1572C72.6113 37.7185 72.671 37.499 72.8396 37.499C72.9182 37.499 73.0244 37.6685 73.0755 37.876Z" fill="#0094E8"/>
                                        <path d="M14.8556 38.1274C14.9457 38.473 15.3779 40.2865 15.8156 42.1572L16.6117 45.5587L15.5743 46.5962L14.5368 47.6336L13.5137 46.6104L12.4907 45.5874L13.3551 41.9201C13.8307 39.9033 14.2615 38.0835 14.3126 37.876C14.4506 37.3163 14.6704 37.418 14.8556 38.1274Z" fill="#0094E8"/>
                                    </svg>                                     
                                    <span><?php _e( 'HR Records Management', 'fintax' ); ?></span>
                                </div>
                                
                                      <?php the_field('service_4_descrription'); ?>
                                
                                <div class="d_flex details_block">
                                    <div class="gray_blue_line"></div>
                                    <div class="d_flex details">
                                        <span><?php _e( 'Learn more', 'fintax' ); ?> </span>
                                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M0.592773 10.6968C0.592773 16.4835 5.28125 21.172 11.0679 21.172C16.8546 21.172 21.5431 16.4835 21.5431 10.6968C21.5431 4.91015 16.8546 0.22168 11.0679 0.22168C5.28125 0.22168 0.592773 4.91015 0.592773 10.6968ZM19.5156 10.6968C19.5156 15.3853 15.7142 19.1445 11.0679 19.1445C6.37945 19.1445 2.62022 15.3853 2.62022 10.6968C2.62022 6.05059 6.37945 2.24913 11.0679 2.24913C15.7142 2.24913 19.5156 6.05059 19.5156 10.6968ZM14.9539 11.077C15.1651 10.8658 15.1651 10.5701 14.9539 10.3589L9.75853 5.16359C9.58958 4.95239 9.25167 4.95239 9.04047 5.16359L8.11123 6.13507C7.90004 6.30402 7.90004 6.64193 8.11123 6.85313L11.9549 10.6968L8.11123 14.5828C7.90004 14.794 7.90004 15.0896 8.11123 15.3008L9.04047 16.2723C9.25167 16.4413 9.58958 16.4413 9.75853 16.2723L14.9539 11.077Z" fill="#282828"/>
                                        </svg>                                        
                                    </div>
                                </div>
                            </div>
                        </a>
                        <a href="<?php the_field('but_5'); ?>" class="d_flex for_service_product">
                            <div class="service_products">
                                <div class="d_flex svg_title">
                                    <svg width="86" height="86" viewBox="0 0 86 86" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M12.7157 0.190277C8.73892 0.945353 4.9803 3.39608 2.68692 6.72941C1.91073 7.85733 0.889049 10.1205 0.478165 11.6217C-0.0382901 13.5082 -0.0346035 17.3797 0.485203 19.2937C1.23961 22.0711 2.75563 24.6317 4.80703 26.5933C6.22452 27.9488 7.14599 28.5844 8.92979 29.437C13.8661 31.7969 19.6746 31.3304 24.306 28.2022C25.4134 27.4541 27.2544 25.6408 28.0884 24.4764C29.0522 23.1308 30.081 20.951 30.5343 19.2937C30.8355 18.1921 30.9009 17.5051 30.9009 15.4396C30.9009 12.5222 30.6149 11.1806 29.4923 8.8326C28.6221 7.01244 27.6435 5.65679 26.2099 4.28589C23.3215 1.52381 20.0448 0.151568 16.0112 0.0146625C14.679 -0.0304142 13.5668 0.0287385 12.7157 0.190277ZM17.9022 3.55729C22.2559 4.45647 25.6015 7.4384 27.0974 11.753C27.5195 12.9703 27.5622 13.3094 27.5622 15.4396C27.5622 17.5698 27.5195 17.9089 27.0974 19.1262C26.8418 19.8635 26.3235 20.9946 25.9456 21.6397C25.1307 23.0314 23.0916 25.0949 21.7453 25.8902C18.5512 27.7772 14.4937 28.0976 11.0802 26.7322C2.92119 23.4688 0.755998 13.0686 6.94675 6.87788C9.85897 3.96566 13.9202 2.73468 17.9022 3.55729ZM14.8142 5.80291C13.9489 6.15213 13.9165 6.35623 13.9165 11.4797V16.2428L15.5678 17.8938C17.1694 19.4957 17.2415 19.5451 17.9746 19.5451C18.5593 19.5451 18.8262 19.4492 19.1535 19.1221C20.052 18.2235 19.8325 17.3189 18.3629 15.8634L17.268 14.779V11.0403C17.268 7.02551 17.1704 6.44219 16.4105 5.90999C15.9879 5.61389 15.383 5.57334 14.8142 5.80291ZM51.8488 23.1467C47.6501 24.06 44.286 27.2748 43.2368 31.3771C42.9463 32.5131 42.9064 33.2402 42.9064 37.3914C42.9064 41.5427 42.9463 42.2698 43.2368 43.4057C43.7571 45.44 44.6134 46.8987 46.2595 48.5549L47.6949 49.9992L43.6249 50.9104L39.5549 51.8217V44.724C39.5549 37.0253 39.5425 36.9145 38.638 36.5025C38.0161 36.2191 26.3475 36.2191 25.7256 36.5025C24.937 36.8617 24.6138 37.8695 25.0089 38.7367C25.4066 39.6094 25.7037 39.6536 31.168 39.6536H36.2035V51.3836V63.1136H30.5155H24.8276L24.7762 58.2959L24.7249 53.4783L24.2574 52.5261C23.3759 50.7313 21.851 49.8009 19.7815 49.7952C18.7409 49.7924 18.361 49.8721 17.5726 50.2592C16.494 50.7889 15.7069 51.6008 15.1911 52.7157C14.8627 53.4255 14.8347 53.8117 14.7869 58.2959L14.7355 63.1136H9.04759H3.35955V51.3836V39.6536H8.39507C13.8594 39.6536 14.1565 39.6094 14.5542 38.7367C14.8074 38.181 14.8074 37.7748 14.5542 37.2192C14.1483 36.3285 13.943 36.3022 7.38126 36.3022C0.819507 36.3022 0.614232 36.3285 0.208375 37.2192C0.058231 37.5484 0.0081272 41.103 0.0081272 51.3999C0.0081272 66.3206 -0.021868 65.8333 0.925077 66.2648C1.24229 66.4094 3.22566 66.465 8.05942 66.465H14.7544V68.0353V69.6057L13.8936 69.7199C11.4767 70.0405 9.65135 72.0095 9.44055 74.5234L9.34352 75.6814H5.33773C0.985236 75.6814 0.594292 75.7513 0.208375 76.5984C-0.0694583 77.2082 -0.0694583 84.209 0.208375 84.8188C0.655287 85.7999 -2.33436 85.7357 42.9064 85.7357C88.1471 85.7357 85.1575 85.7999 85.6044 84.8188C85.7545 84.4895 85.8046 80.935 85.8046 70.6381C85.8046 55.7174 85.8346 56.2047 84.8877 55.7732C84.5767 55.6314 82.9043 55.5729 79.1653 55.5729H73.8824L73.0149 54.6218C72.0132 53.5235 70.5898 52.5513 69.2484 52.0494C68.7328 51.8565 66.5483 51.3136 64.394 50.8429L60.4769 49.9869L61.0337 49.5648C63.394 47.7751 64.9572 45.0209 65.369 41.9269C65.6582 39.7535 65.4941 32.6874 65.1235 31.3589C63.493 25.5136 57.6335 21.8887 51.8488 23.1467ZM56.0284 26.498C58.2971 27.0888 60.2468 28.6343 61.2479 30.6353C61.7704 31.6798 62.1668 33.1844 61.9711 33.3801C61.9279 33.4235 60.995 32.9302 59.8983 32.2839C57.3408 30.7769 56.9899 30.7489 55.7827 31.9561C54.6953 33.0435 53.4603 33.8602 52.2 34.3255C51.3831 34.627 50.7509 34.7061 48.7295 34.7596L46.2578 34.8247L46.2598 33.9297C46.2672 30.5991 48.7933 27.4132 52.1404 26.5132C53.3275 26.1938 54.8385 26.188 56.0284 26.498ZM60.0157 36.2349L62.1771 37.5081L62.1757 39.1255C62.1741 41.3954 61.9266 42.7329 61.2526 44.1164C60.5863 45.4838 59.0343 47.0688 57.7559 47.6877C53.6576 49.6715 48.9225 48.0066 46.97 43.895C46.3686 42.6287 46.3468 42.5168 46.2844 40.3864L46.2201 38.1857L48.9621 38.1031C51.968 38.0126 52.7351 37.8476 54.6898 36.8708C55.3182 36.5568 56.2231 36.0001 56.7007 35.6334C57.1781 35.267 57.633 34.9658 57.7116 34.9643C57.7901 34.9628 58.827 35.5346 60.0157 36.2349ZM18.9621 36.5361C17.5094 37.3413 18.1172 39.6536 19.7815 39.6536C20.6306 39.6536 21.4572 38.8351 21.4572 37.9942C21.4572 36.7361 20.0669 35.9237 18.9621 36.5361ZM56.6489 51.8863C56.6538 52.1142 54.2307 58.4216 54.1383 58.4216C54.0529 58.4216 51.6201 52.0864 51.6201 51.8636C51.6201 51.7689 56.6471 51.7917 56.6489 51.8863ZM20.5951 53.2981C21.446 53.7382 21.4572 53.8511 21.4572 62.0323V69.6489H19.7815H18.1058L18.1117 61.9825C18.1181 53.7794 18.1201 53.76 18.9621 53.2933C19.4871 53.0022 20.0259 53.0039 20.5951 53.2981ZM50.4375 58.3797C51.4869 61.2139 52.4779 63.8005 52.6396 64.1279C53.0979 65.0556 54.0314 65.3592 54.9556 64.8813C55.5181 64.5904 55.5501 64.5177 57.9124 58.1703C58.9071 55.4975 59.7268 53.2991 59.734 53.2851C59.7878 53.1803 67.5995 54.9996 68.1258 55.2394L68.7961 55.5446L65.562 55.5588C62.0437 55.5741 61.576 55.6741 61.2043 56.4899C61.0567 56.8138 61.0041 59.3929 61.0041 66.3053V75.6814H48.52H36.0359V71.0732V66.465H37.1335C38.3885 66.465 39.064 66.1862 39.3547 65.5481C39.4951 65.2399 39.5549 63.6663 39.5549 60.2773V55.4461L40.0855 55.2262C40.4649 55.069 47.0884 53.4974 48.4411 53.2435C48.4898 53.2344 49.3882 55.5456 50.4375 58.3797ZM82.4532 60.6V62.2758H73.4043H64.3555V60.6V58.9243H73.4043H82.4532V60.6ZM82.4532 67.3029V68.9786H73.4043H64.3555V67.3029V65.6272H73.4043H82.4532V67.3029ZM32.6845 71.0732V75.6814H31.4507H30.2169L30.1319 74.6239C29.9233 72.0235 28.1031 70.0492 25.6046 69.7129L24.8087 69.6057V68.0353V66.465H28.7466H32.6845V71.0732ZM82.4532 74.0057V75.6814H73.4043H64.3555V74.0057V72.33H73.4043H82.4532V74.0057ZM25.8196 73.2545C26.4221 73.566 26.8195 74.2945 26.8195 75.0866V75.6814H19.7815H12.7435V75.0866C12.7435 74.3127 13.1343 73.5746 13.7093 73.2626C14.3978 72.889 25.0989 72.8818 25.8196 73.2545ZM82.4532 80.7086V82.3843H42.9064H3.35955V80.7086V79.0329H42.9064H82.4532V80.7086Z" fill="#282828"/>
                                        <path d="M82.4532 60.6V62.2758H73.4043H64.3555V60.6V58.9243H73.4043H82.4532V60.6Z" fill="#238DC1"/>
                                        <path d="M82.4532 74.0057V75.6814H73.4043H64.3555V74.0057V72.33H73.4043H82.4532V74.0057Z" fill="#238DC1"/>
                                        <path d="M56.6489 51.8863C56.6538 52.1142 54.2307 58.4216 54.1383 58.4216C54.0529 58.4216 51.6201 52.0864 51.6201 51.8636C51.6201 51.7689 56.6471 51.7917 56.6489 51.8863Z" fill="#238DC1"/>
                                        <path d="M82.4532 67.3029V68.9786H73.4043H64.3555V67.3029V65.6272H73.4043H82.4532V67.3029Z" fill="white"/>
                                        </svg>                                                                           
                                    <span><?php _e( 'Company Registration', 'fintax' ); ?></span>
                                </div>
                                
                                     <?php the_field('service_5_descrription'); ?>
                                
                                <div class="d_flex details_block">
                                    <div class="gray_blue_line"></div>
                                    <div class="d_flex details">
                                        <span><?php _e( 'Learn more', 'fintax' ); ?> </span>
                                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M0.592773 10.6968C0.592773 16.4835 5.28125 21.172 11.0679 21.172C16.8546 21.172 21.5431 16.4835 21.5431 10.6968C21.5431 4.91015 16.8546 0.22168 11.0679 0.22168C5.28125 0.22168 0.592773 4.91015 0.592773 10.6968ZM19.5156 10.6968C19.5156 15.3853 15.7142 19.1445 11.0679 19.1445C6.37945 19.1445 2.62022 15.3853 2.62022 10.6968C2.62022 6.05059 6.37945 2.24913 11.0679 2.24913C15.7142 2.24913 19.5156 6.05059 19.5156 10.6968ZM14.9539 11.077C15.1651 10.8658 15.1651 10.5701 14.9539 10.3589L9.75853 5.16359C9.58958 4.95239 9.25167 4.95239 9.04047 5.16359L8.11123 6.13507C7.90004 6.30402 7.90004 6.64193 8.11123 6.85313L11.9549 10.6968L8.11123 14.5828C7.90004 14.794 7.90004 15.0896 8.11123 15.3008L9.04047 16.2723C9.25167 16.4413 9.58958 16.4413 9.75853 16.2723L14.9539 11.077Z" fill="#282828"/>
                                        </svg>                                        
                                    </div>
                                </div>
                            </div>
                        </a>
                        <a href="<?php the_field('but_6'); ?>" class="d_flex for_service_product">
                            <div class="service_products">
                                <div class="d_flex svg_title">
                                    <svg width="78" height="86" viewBox="0 0 78 86" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M18.8318 0.311675C17.5389 0.758577 16.6807 1.5309 16.047 2.81798L15.4966 3.93599L15.4496 16.4586L15.4025 28.9814L14.7794 29.0862C9.92041 29.9022 6.37653 31.5449 5.21562 33.519C4.78196 34.2565 4.77107 34.3471 4.71829 37.6355L4.6645 40.9979L3.41478 41.6162C1.93449 42.3488 0.814469 43.3301 0.340086 44.3098C0.0215408 44.9677 -0.00309154 45.3238 0.000259811 49.1976C0.00344359 52.8811 0.040141 53.4555 0.310092 54.0495C0.741075 54.9984 2.10574 56.1592 3.67401 56.9109C4.92942 57.5126 5.00466 57.5786 4.89222 57.9776C4.73655 58.5291 4.73554 66.3161 4.89105 66.8666C5.00231 67.2604 4.92339 67.3281 3.65675 67.9254C2.11429 68.6528 0.763194 69.8146 0.310762 70.8027C0.0394707 71.3956 0.0039465 71.9571 0.0039465 75.6622C0.0039465 80.4591 0.0512005 80.6731 1.38236 81.8952C3.31994 83.6744 7.19326 84.9343 12.6662 85.5657C14.8911 85.8226 14.9699 85.8208 15.3945 85.5052C15.697 85.2804 15.8476 84.9947 15.8831 84.5781C15.9602 83.6747 15.5309 83.3399 14.129 83.2107C8.9254 82.7308 4.65729 81.5017 3.10227 80.0352L2.51008 79.4767V77.6222V75.7677L3.95032 76.4427C5.56634 77.1999 8.25295 77.9285 11.0858 78.3776C13.8135 78.8101 22.039 78.8101 24.7667 78.3776C27.5996 77.9285 30.2862 77.1999 31.9022 76.4427L33.3425 75.7677V77.6222V79.4767L32.7503 80.0352C31.1683 81.5272 26.4647 82.8568 21.4963 83.2166C19.7048 83.3465 19.2668 83.607 19.2668 84.5432C19.2668 85.2968 19.7998 85.8 20.5981 85.8C21.4898 85.8 25.1829 85.3462 26.8073 85.0372C28.7568 84.6662 31.1884 83.8728 32.5465 83.1645C34.6969 82.0431 35.856 80.6314 35.856 79.1337V78.4381L54.4978 78.3907L73.1397 78.3433L74.0725 77.9057C75.1758 77.3883 76.0837 76.504 76.6117 75.4321C76.9911 74.6621 76.9941 74.6008 77.0417 66.602C77.0891 58.6264 77.0861 58.5427 76.7362 58.0979C76.2762 57.513 75.5383 57.497 74.9754 58.0601L74.564 58.4713V66.1087C74.564 74.3699 74.5607 74.4034 73.6505 75.2433L73.1965 75.6622L54.5263 75.7062L35.856 75.7503L35.8442 73.6117C35.8377 72.4353 35.7739 71.3229 35.7022 71.1394C35.5884 70.8478 35.7504 70.7176 36.9842 70.1085C37.7611 69.7251 38.5602 69.2608 38.7601 69.0766C39.0644 68.7964 39.4114 68.7319 40.8934 68.6802C42.3742 68.6284 42.7946 68.5503 43.4671 68.2024C45.7274 67.0328 46.1086 63.9 44.1903 62.258C43.3983 61.58 42.6711 61.3373 41.4276 61.3362L40.5479 61.3352V60.0784V58.8217H41.4082C43.9525 58.8217 45.5492 57.2118 45.3763 54.821C45.2857 53.5667 44.7127 52.6505 43.6184 52.009C42.8956 51.5854 42.6497 51.5395 40.7672 51.4768C38.3683 51.3971 37.3852 51.5871 36.4844 52.3045L35.856 52.805V50.2871V47.7691L36.6229 48.3103L37.3901 48.8514L40.0426 48.9047C42.4188 48.9523 42.7623 48.9233 43.339 48.6267C46.026 47.2451 46.1071 43.498 43.4803 42.1033C43.2038 41.9563 42.4498 41.7935 41.8046 41.7412L40.6316 41.646V39.2163V36.7866L41.8046 36.6994C43.079 36.6047 43.7402 36.3239 44.4247 35.5866C45.1154 34.8426 45.4076 34.1152 45.4036 33.1503C45.3991 32.0426 44.9733 31.0801 44.1797 30.3833C43.279 29.5924 42.6282 29.4632 39.8645 29.5257C37.5172 29.579 37.3942 29.5994 36.7176 30.0477L36.0135 30.5142L34.689 30.0958C30.9156 28.9039 28.3984 28.5868 22.6559 28.5808L17.9179 28.5758L17.964 16.3975C18.0094 4.39512 18.0151 4.21248 18.3556 3.75652C18.5456 3.50199 18.9092 3.13837 19.1634 2.94835C19.6063 2.61757 19.8701 2.60081 25.3492 2.5544C30.9295 2.50731 31.082 2.49709 31.4535 2.14821C31.9624 1.67014 31.9592 0.85141 31.4466 0.369821C31.0639 0.0103892 30.9838 0.00552972 25.3723 0.0110594C20.3863 0.0157513 19.5805 0.0527837 18.8318 0.311675ZM35.5527 0.390599C35.0671 0.907377 35.0753 1.68657 35.5713 2.15257L35.9567 2.51468L54.4645 2.55875L72.9721 2.60282L73.4961 2.9765C74.6428 3.79456 74.564 1.87541 74.564 28.9891C74.564 44.3482 74.6242 53.5939 74.7252 53.7827C74.8139 53.9483 75.1078 54.1755 75.3782 54.2876C75.7854 54.4562 75.9594 54.4451 76.3877 54.2238C76.6722 54.0765 76.9462 53.7878 76.9961 53.5822C77.0462 53.3764 77.0661 42.0482 77.0405 28.4082L76.9938 3.60823L76.6157 2.90076C76.0522 1.84609 75.3613 1.13426 74.3661 0.582967L73.4748 0.0893134L54.6972 0.0445729L35.9197 0L35.5527 0.390599ZM23.1209 9.3893C22.7968 9.71338 22.7857 9.9478 22.7857 16.4849C22.7857 23.1451 22.7909 23.2501 23.1385 23.5647C23.4816 23.8753 24.1052 23.8839 46.2773 23.8839H69.0633L69.4678 23.4137L69.8721 22.9435V16.4102V9.87675L69.4608 9.46554L69.0496 9.05417H46.2527C23.6794 9.05417 23.4526 9.05752 23.1209 9.3893ZM67.3193 16.469L67.2748 21.3704L46.287 21.4129L25.2992 21.4555V16.5116V11.5677H46.3315H67.3637L67.3193 16.469ZM10.6597 16.9421C9.77429 17.6385 10.2706 19.1082 11.3912 19.1082C12.5505 19.1082 13.0125 17.7672 12.1273 16.9717C11.6058 16.5032 11.2273 16.4955 10.6597 16.9421ZM6.27281 21.3628C6.04659 21.589 5.86143 21.9694 5.86143 22.2082C5.86143 22.447 6.04659 22.8274 6.27281 23.0536C6.67162 23.4526 6.75741 23.465 9.11341 23.465C11.77 23.465 12.291 23.3384 12.5366 22.6342C12.7233 22.0986 12.4163 21.2268 11.9825 21.0604C11.8265 21.0004 10.5706 20.9514 9.19149 20.9514C6.75272 20.9514 6.67279 20.9627 6.27281 21.3628ZM6.57108 24.9793C6.20394 25.1267 5.86143 25.7392 5.86143 26.2484C5.86143 26.3848 6.04659 26.6814 6.27281 26.9076C6.67413 27.3091 6.74669 27.319 9.28902 27.319C11.6705 27.319 11.9227 27.2902 12.229 26.9839C12.7736 26.4393 12.7334 25.7271 12.1273 25.1825C11.7323 24.8278 11.5674 24.8062 9.32907 24.8161C8.02087 24.8219 6.77987 24.8953 6.57108 24.9793ZM49.434 29.6839C48.1963 30.1777 47.0882 31.7403 47.0847 32.9969C47.0805 34.4158 47.9515 35.8341 49.1657 36.3856C50.1847 36.8484 54.5248 36.8465 55.4262 36.3831C58.1754 34.9688 58.147 31.0971 55.3776 29.8151C54.8197 29.5569 54.2996 29.5059 52.2776 29.5116C50.9412 29.5155 49.6615 29.5929 49.434 29.6839ZM61.1967 29.852C59.0679 30.9058 58.5109 33.604 60.0395 35.4583C60.9071 36.5109 61.5523 36.6949 64.391 36.6991C66.5055 36.7023 66.9605 36.6559 67.491 36.3831C70.2403 34.9688 70.2118 31.0971 67.4424 29.8151C66.8888 29.5587 66.3492 29.5041 64.3424 29.5012C62.2018 29.4981 61.8276 29.5398 61.1967 29.852ZM27.1666 31.1762C32.9629 31.7463 38.0344 33.5983 38.0344 35.1447C38.0344 36.5629 33.8561 38.2665 28.5861 38.9976C25.7656 39.3887 19.4335 39.383 16.6695 38.9867C12.4797 38.3862 8.64925 37.0565 7.63479 35.8509C7.39668 35.568 7.20197 35.2696 7.20197 35.1876C7.20197 34.8331 8.3374 33.7933 9.1982 33.3596C11.0775 32.4131 14.6435 31.5285 17.9263 31.1948C19.9714 30.9869 25.1365 30.9765 27.1666 31.1762ZM42.5873 32.2882C42.9692 32.6337 42.9846 33.4761 42.6165 33.8828C42.4087 34.1124 42.0962 34.1893 41.371 34.1893C40.5281 34.1893 40.3882 34.1427 40.2888 33.8297C40.226 33.6319 39.8721 33.1418 39.5021 32.7405L38.8295 32.0109H40.5552C41.9259 32.0109 42.344 32.068 42.5873 32.2882ZM54.6522 32.2882C55.0341 32.6337 55.0495 33.4761 54.6813 33.8828C54.4412 34.1482 54.1267 34.1893 52.3354 34.1893C50.4901 34.1893 50.2306 34.1531 49.9316 33.8541C49.7473 33.6698 49.5965 33.3305 49.5965 33.1001C49.5965 32.8697 49.7473 32.5303 49.9316 32.346C50.2301 32.0476 50.4901 32.0109 52.3062 32.0109C53.9688 32.0109 54.4023 32.0622 54.6522 32.2882ZM66.717 32.2882C67.0989 32.6337 67.1143 33.4761 66.7462 33.8828C66.5061 34.1482 66.1915 34.1893 64.4002 34.1893C62.555 34.1893 62.2954 34.1531 61.9965 33.8541C61.8122 33.6698 61.6613 33.3305 61.6613 33.1001C61.6613 32.8697 61.8122 32.5303 61.9965 32.346C62.2949 32.0476 62.555 32.0109 64.3711 32.0109C66.0337 32.0109 66.4672 32.0622 66.717 32.2882ZM8.98086 39.6082C16.1707 42.692 29.9978 42.5904 36.86 39.4036C37.3676 39.1679 37.8396 38.9477 37.9087 38.9142C38.0952 38.8237 38.0612 42.3721 37.872 42.7253C37.7828 42.8922 37.3395 43.2664 36.8867 43.5568C32.2343 46.5422 20.0569 47.287 12.0614 45.0751C10.3539 44.6027 8.17118 43.5261 7.63915 42.8941C7.22844 42.4059 7.20197 42.2672 7.20197 40.6098C7.20197 39.262 7.2514 38.8666 7.41143 38.9351C7.52671 38.9845 8.23284 39.2875 8.98086 39.6082ZM49.1318 42.0844C46.4335 43.42 46.4422 47.2759 49.1466 48.585C49.7791 48.8913 50.1731 48.9347 52.2886 48.9315C54.9627 48.9275 55.6308 48.7519 56.4998 47.8252C58.1813 46.0321 57.6079 43.0801 55.3776 42.0475C54.8239 41.7911 54.2844 41.7365 52.2776 41.7337C50.1369 41.7305 49.7627 41.7722 49.1318 42.0844ZM61.1967 42.0844C59.0679 43.1382 58.5109 45.8364 60.0395 47.6907C60.9048 48.7405 61.5564 48.9278 64.3424 48.9278C67.0292 48.9278 67.6933 48.7544 68.5646 47.8252C70.2462 46.0321 69.6727 43.0801 67.4424 42.0475C66.8888 41.7911 66.3492 41.7365 64.3424 41.7337C62.2018 41.7305 61.8276 41.7722 61.1967 42.0844ZM7.50862 45.9118C9.5345 47.1117 13.1771 48.1163 17.3398 48.6228C19.1428 48.8422 25.3592 48.9122 27.1425 48.7331L28.2317 48.6238L26.9781 48.9411C23.4089 49.8444 16.5802 50.1147 12.1452 49.5282C8.06829 48.9891 4.55541 47.8477 3.13511 46.6006C2.79126 46.2989 2.51008 45.919 2.51008 45.7566C2.51008 45.2874 3.14365 44.6061 4.07432 44.0747L4.93378 43.5838L5.66236 44.4167C6.06318 44.8749 6.89398 45.5476 7.50862 45.9118ZM42.5873 44.5206C42.9692 44.8661 42.9846 45.7085 42.6165 46.1152C42.3767 46.3803 42.0652 46.4213 40.3124 46.4192C37.9657 46.4161 37.5276 46.2618 38.2762 45.7016C38.5474 45.4986 39.0376 45.0895 39.3653 44.7924C39.9145 44.2949 40.0527 44.252 41.1211 44.2478C41.97 44.2445 42.3631 44.3177 42.5873 44.5206ZM54.6522 44.5206C55.0341 44.8661 55.0495 45.7085 54.6813 46.1152C54.4412 46.3806 54.1267 46.4217 52.3354 46.4217C50.4901 46.4217 50.2306 46.3855 49.9316 46.0865C49.7473 45.9022 49.5965 45.5629 49.5965 45.3325C49.5965 45.1021 49.7473 44.7628 49.9316 44.5784C50.2301 44.28 50.4901 44.2433 52.3062 44.2433C53.9688 44.2433 54.4023 44.2946 54.6522 44.5206ZM66.717 44.5206C67.0989 44.8661 67.1143 45.7085 66.7462 46.1152C66.5061 46.3806 66.1915 46.4217 64.4002 46.4217C62.555 46.4217 62.2954 46.3855 61.9965 46.0865C61.8122 45.9022 61.6613 45.5629 61.6613 45.3325C61.6613 45.1021 61.8122 44.7628 61.9965 44.5784C62.2949 44.28 62.555 44.2433 64.3711 44.2433C66.0337 44.2433 66.4672 44.2946 66.717 44.5206ZM5.42542 50.6003C7.15438 51.2049 10.2142 51.8475 12.7317 52.1347C14.9655 52.3896 20.8235 52.3872 23.1209 52.1305C26.8318 51.716 30.7961 50.697 32.6303 49.6864L33.3425 49.2939V51.1126C33.3425 52.8281 33.3177 52.9605 32.9053 53.4508C32.3749 54.081 30.1962 55.1499 28.483 55.6205C23.6529 56.9471 16.1424 57.2361 10.6275 56.3076C6.96821 55.6915 3.84911 54.5224 2.92046 53.4188C2.54025 52.9669 2.51008 52.7976 2.51008 51.1126V49.2939L3.22224 49.6864C3.61385 49.9022 4.60534 50.3134 5.42542 50.6003ZM49.6985 51.6479C48.7582 51.9082 47.5014 53.1805 47.2489 54.1281C46.7913 55.8455 47.525 57.5445 49.0737 58.3535C49.9211 58.7962 50.0888 58.8217 52.1516 58.8217C54.7753 58.8217 55.4838 58.6382 56.4033 57.7199C57.2495 56.875 57.5318 56.0741 57.4386 54.7841C57.3482 53.5337 56.6849 52.5511 55.5264 51.9514C54.798 51.5742 54.4995 51.5293 52.534 51.5C51.333 51.482 50.0571 51.5487 49.6985 51.6479ZM61.7634 51.6479C60.823 51.9082 59.5662 53.1805 59.3137 54.1281C58.8561 55.8455 59.5899 57.5445 61.1385 58.3535C61.9859 58.7962 62.1537 58.8217 64.2164 58.8217C66.6508 58.8217 67.4062 58.6606 68.2558 57.9604C70.2061 56.3527 69.8599 53.1108 67.615 51.9596C66.8616 51.5732 66.5736 51.5293 64.5988 51.5C63.3978 51.482 62.122 51.5487 61.7634 51.6479ZM42.4523 54.3096C42.9925 54.7344 43.0409 55.4908 42.5587 55.973C42.279 56.2527 42.0002 56.3082 40.8748 56.3082C39.5627 56.3082 39.4992 56.2892 38.5374 55.6109C37.6873 55.0115 37.5725 54.8691 37.7187 54.5961C37.9817 54.1045 38.4824 53.9843 40.3158 53.9728C41.7865 53.9635 42.0692 54.0081 42.4523 54.3096ZM54.5171 54.3096C55.0594 54.736 55.1053 55.4913 54.6183 55.9782C54.308 56.2885 54.1002 56.3142 52.2483 56.2715C50.2529 56.2252 50.2125 56.2165 49.875 55.7639C49.5997 55.3947 49.5635 55.2126 49.6925 54.8458C49.9378 54.148 50.489 53.9674 52.3806 53.9647C53.844 53.9625 54.1359 54.0096 54.5171 54.3096ZM66.582 54.3096C67.1222 54.7344 67.1706 55.4908 66.6884 55.973C66.3914 56.2699 66.1299 56.3082 64.395 56.3082C62.6153 56.3082 62.4017 56.275 62.0491 55.9439C61.5477 55.4727 61.5564 54.8897 62.0727 54.3736C62.4591 53.987 62.5945 53.9622 64.3123 53.9622C65.908 53.9622 66.1965 54.0063 66.582 54.3096ZM35.6884 56.9127C37.0899 57.5693 38.0344 58.3714 38.0344 58.9054C38.0344 59.8525 35.5996 61.2098 32.4946 61.9935C29.7032 62.698 26.5957 63.0308 22.781 63.0335C19.2197 63.036 16.9195 62.8421 14.3236 62.3205C9.84166 61.42 6.40887 59.543 7.41076 58.541C7.63714 58.3146 7.79499 58.3019 8.42052 58.4594C12.3716 59.4544 19.9701 59.6556 25.0578 58.9001C28.2231 58.43 31.459 57.4505 33.013 56.4916C33.7037 56.0655 33.9687 56.1071 35.6884 56.9127ZM49.0737 61.8034C46.4204 63.1895 46.47 66.8168 49.1617 68.2572C49.7775 68.5866 50.0975 68.6244 52.2821 68.6244C54.5612 68.6244 54.7693 68.5972 55.5497 68.1972C56.7037 67.6059 57.4722 66.3438 57.4722 65.0401C57.4722 63.4063 56.4495 61.9692 54.9717 61.5264C54.6205 61.4213 53.3515 61.3352 52.1516 61.3352C50.0888 61.3352 49.9211 61.3606 49.0737 61.8034ZM61.1385 61.8034C59.5899 62.6124 58.8561 64.3113 59.3137 66.0287C59.5872 67.0549 60.8156 68.2468 61.8745 68.5134C62.8452 68.7579 65.8819 68.7654 66.7721 68.5258C69.6379 67.754 70.5059 64.0513 68.2558 62.1965C67.4062 61.4962 66.6508 61.3352 64.2164 61.3352C62.1537 61.3352 61.9859 61.3606 61.1385 61.8034ZM11.5766 64.2678C17.4433 65.8536 25.8401 66.0175 32.1152 64.6689C33.8695 64.2919 36.112 63.5642 37.1479 63.0356C37.536 62.8377 37.8941 62.6757 37.9439 62.6757C37.9936 62.6757 38.0344 63.4973 38.0344 64.5015V66.3275L37.4093 66.8763C36.1331 67.9968 33.6045 68.9022 29.9073 69.5627C27.0701 70.0695 20.6566 70.1975 17.3398 69.8136C14.1155 69.4402 11.3276 68.7267 9.43279 67.7897C7.29949 66.7347 7.20197 66.5839 7.20197 64.3397V62.5299L8.60233 63.1861C9.37247 63.5471 10.7108 64.0338 11.5766 64.2678ZM42.5587 64.1838C43.3982 65.0233 42.6197 66.257 41.311 66.1608L40.6316 66.1108L40.5821 64.9798L40.5326 63.8487H41.378C42.0002 63.8487 42.3122 63.9373 42.5587 64.1838ZM54.6235 64.1838C55.1125 64.6728 55.0573 65.4225 54.5 65.8608C54.0806 66.1908 53.8793 66.2167 52.139 66.1661C50.3754 66.1149 50.2131 66.082 49.9166 65.7152C49.4973 65.1969 49.5117 64.7147 49.9608 64.2364C50.3018 63.8735 50.4521 63.8487 52.3067 63.8487C54.065 63.8487 54.3261 63.8864 54.6235 64.1838ZM66.6884 64.1838C67.1773 64.6728 67.1222 65.4225 66.5649 65.8608C66.1454 66.1908 65.9442 66.2167 64.2038 66.1661C62.4402 66.1149 62.278 66.082 61.9814 65.7152C61.5621 65.1969 61.5766 64.7147 62.0256 64.2364C62.3666 63.8735 62.5169 63.8487 64.3716 63.8487C66.1299 63.8487 66.3909 63.8864 66.6884 64.1838ZM7.88732 69.8806C9.89176 70.9912 13.8696 72.0018 17.811 72.4016C20.9039 72.7155 27.5249 72.5285 30.1587 72.0528C32.9299 71.5522 33.2453 71.5466 33.3091 71.9945C33.4698 73.1197 30.8033 74.5499 26.9221 75.4204C21.7941 76.5704 13.5789 76.529 8.5844 75.3277C5.61678 74.6139 3.35311 73.5724 2.74183 72.6396C2.38675 72.0977 2.58549 71.6044 3.41277 70.9733C3.98786 70.5348 6.43233 69.3846 6.79813 69.3804C6.89867 69.3792 7.3888 69.6044 7.88732 69.8806Z" fill="#353535"/>
                                        <path d="M66.582 54.3096C67.1222 54.7344 67.1706 55.4908 66.6884 55.973C66.3914 56.2699 66.1299 56.3082 64.395 56.3082C62.6153 56.3082 62.4017 56.275 62.0491 55.9439C61.5477 55.4727 61.5564 54.8897 62.0727 54.3736C62.4591 53.987 62.5945 53.9622 64.3123 53.9622C65.908 53.9622 66.1965 54.0063 66.582 54.3096Z" fill="#0094E8"/>
                                        <path d="M42.4523 54.3096C42.9925 54.7344 43.0409 55.4908 42.5587 55.973C42.279 56.2527 42.0002 56.3082 40.8748 56.3082C39.5627 56.3082 39.4992 56.2892 38.5374 55.6109C37.6873 55.0115 37.5725 54.8691 37.7187 54.5961C37.9817 54.1045 38.4824 53.9843 40.3158 53.9728C41.7865 53.9635 42.0692 54.0081 42.4523 54.3096Z" fill="#0094E8"/>
                                        <path d="M42.5873 44.5206C42.9692 44.8661 42.9846 45.7085 42.6165 46.1152C42.3767 46.3803 42.0652 46.4213 40.3124 46.4192C37.9657 46.4161 37.5276 46.2618 38.2762 45.7016C38.5474 45.4986 39.0376 45.0895 39.3653 44.7924C39.9145 44.2949 40.0527 44.252 41.1211 44.2478C41.97 44.2445 42.3631 44.3177 42.5873 44.5206Z" fill="#0094E8"/>
                                        <path d="M54.6522 44.5206C55.0341 44.8661 55.0495 45.7085 54.6813 46.1152C54.4412 46.3806 54.1267 46.4217 52.3354 46.4217C50.4901 46.4217 50.2306 46.3855 49.9316 46.0865C49.7473 45.9022 49.5965 45.5629 49.5965 45.3325C49.5965 45.1021 49.7473 44.7628 49.9316 44.5784C50.2301 44.28 50.4901 44.2433 52.3062 44.2433C53.9688 44.2433 54.4023 44.2946 54.6522 44.5206Z" fill="#0094E8"/>
                                        <path d="M66.717 44.5206C67.0989 44.8661 67.1143 45.7085 66.7462 46.1152C66.5061 46.3806 66.1915 46.4217 64.4002 46.4217C62.555 46.4217 62.2954 46.3855 61.9965 46.0865C61.8122 45.9022 61.6613 45.5629 61.6613 45.3325C61.6613 45.1021 61.8122 44.7628 61.9965 44.5784C62.2949 44.28 62.555 44.2433 64.3711 44.2433C66.0337 44.2433 66.4672 44.2946 66.717 44.5206Z" fill="#0094E8"/>
                                        <path d="M66.717 32.2882C67.0989 32.6337 67.1143 33.4761 66.7462 33.8828C66.5061 34.1482 66.1915 34.1893 64.4002 34.1893C62.555 34.1893 62.2954 34.1531 61.9965 33.8541C61.8122 33.6698 61.6613 33.3305 61.6613 33.1001C61.6613 32.8697 61.8122 32.5303 61.9965 32.346C62.2949 32.0476 62.555 32.0109 64.3711 32.0109C66.0337 32.0109 66.4672 32.0622 66.717 32.2882Z" fill="#0094E8"/>
                                        <path d="M54.6522 32.2882C55.0341 32.6337 55.0495 33.4761 54.6813 33.8828C54.4412 34.1482 54.1267 34.1893 52.3354 34.1893C50.4901 34.1893 50.2306 34.1531 49.9316 33.8541C49.7473 33.6698 49.5965 33.3305 49.5965 33.1001C49.5965 32.8697 49.7473 32.5303 49.9316 32.346C50.2301 32.0476 50.4901 32.0109 52.3062 32.0109C53.9688 32.0109 54.4023 32.0622 54.6522 32.2882Z" fill="#0094E8"/>
                                        <path d="M42.5873 32.2882C42.9692 32.6337 42.9846 33.4761 42.6165 33.8828C42.4087 34.1124 42.0962 34.1893 41.371 34.1893C40.5281 34.1893 40.3882 34.1427 40.2888 33.8297C40.226 33.6319 39.8721 33.1418 39.5021 32.7405L38.8295 32.0109H40.5552C41.9259 32.0109 42.344 32.068 42.5873 32.2882Z" fill="#0094E8"/>
                                        <path d="M42.5587 64.1838C43.3982 65.0233 42.6197 66.257 41.311 66.1608L40.6316 66.1108L40.5821 64.9798L40.5326 63.8487H41.378C42.0002 63.8487 42.3122 63.9373 42.5587 64.1838Z" fill="#0094E8"/>
                                        <path d="M54.6235 64.1838C55.1125 64.6728 55.0573 65.4225 54.5 65.8608C54.0806 66.1908 53.8793 66.2167 52.139 66.1661C50.3754 66.1149 50.2131 66.082 49.9166 65.7152C49.4973 65.1969 49.5117 64.7147 49.9608 64.2364C50.3018 63.8735 50.4521 63.8487 52.3067 63.8487C54.065 63.8487 54.3261 63.8864 54.6235 64.1838Z" fill="#0094E8"/>
                                        <path d="M66.6884 64.1838C67.1773 64.6728 67.1222 65.4225 66.5649 65.8608C66.1454 66.1908 65.9442 66.2167 64.2038 66.1661C62.4402 66.1149 62.278 66.082 61.9814 65.7152C61.5621 65.1969 61.5766 64.7147 62.0256 64.2364C62.3666 63.8735 62.5169 63.8487 64.3716 63.8487C66.1299 63.8487 66.3909 63.8864 66.6884 64.1838Z" fill="#40C700"/>
                                        <path d="M54.5171 54.3096C55.0594 54.736 55.1053 55.4913 54.6183 55.9782C54.308 56.2885 54.1002 56.3142 52.2483 56.2715C50.2529 56.2252 50.2125 56.2165 49.875 55.7639C49.5997 55.3947 49.5635 55.2126 49.6925 54.8458C49.9378 54.148 50.489 53.9674 52.3806 53.9647C53.844 53.9625 54.1359 54.0096 54.5171 54.3096Z" fill="#0094E8"/>
                                    </svg>                                      
                                    <span>
                                    <?php _e( 'Accounting for the USA', 'fintax' ); ?> </span>
                                </div>
                               
                                      <?php the_field('service_6_descrription'); ?>
                                
                                <div class="d_flex details_block">
                                    <div class="gray_blue_line"></div>
                                    <div class="d_flex details">
                                        <span><?php _e( 'Learn more', 'fintax' ); ?>  </span>
                                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M0.592773 10.6968C0.592773 16.4835 5.28125 21.172 11.0679 21.172C16.8546 21.172 21.5431 16.4835 21.5431 10.6968C21.5431 4.91015 16.8546 0.22168 11.0679 0.22168C5.28125 0.22168 0.592773 4.91015 0.592773 10.6968ZM19.5156 10.6968C19.5156 15.3853 15.7142 19.1445 11.0679 19.1445C6.37945 19.1445 2.62022 15.3853 2.62022 10.6968C2.62022 6.05059 6.37945 2.24913 11.0679 2.24913C15.7142 2.24913 19.5156 6.05059 19.5156 10.6968ZM14.9539 11.077C15.1651 10.8658 15.1651 10.5701 14.9539 10.3589L9.75853 5.16359C9.58958 4.95239 9.25167 4.95239 9.04047 5.16359L8.11123 6.13507C7.90004 6.30402 7.90004 6.64193 8.11123 6.85313L11.9549 10.6968L8.11123 14.5828C7.90004 14.794 7.90004 15.0896 8.11123 15.3008L9.04047 16.2723C9.25167 16.4413 9.58958 16.4413 9.75853 16.2723L14.9539 11.077Z" fill="#282828"/>
                                        </svg>                                        
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </section>
            <section class="aboutus">
                <div class="d_flex col_sec  wrapper">
                    <?php if( have_rows('about') ): ?>
                    <?php while( have_rows('about') ): the_row(); 

                    // Get sub field values.
                    $image = get_sub_field('image');

                    ?>
                    <div class="link_block d_flex">
                        <div class="green_title"></div>
                        <a class="title_link" href="<?php the_sub_field('sub_title_url'); ?>"> <?php the_sub_field('sub_title'); ?></a>
                    </div>  
                    <h3><?php the_sub_field('title'); ?></h3>
                    <div class="d_flex usa_accounting_block">
                        <div class="usa_accounting_img">
                             <img src="<?php echo get_template_directory_uri() ?>/img/FINTAX-Logo-files-03-scaled.jpg">
                        </div>
                        <div class="d_flex usa_rows">
                             <p>
                                <?php the_sub_field('description'); ?>
                             </p>
                             <a class="request_for_meeting d_flex" href="<?php the_sub_field('button_url'); ?>">
                                  <?php the_sub_field('buttone_name'); ?>
                                <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M0 10.5C0 16.3004 4.6996 21 10.5 21C16.3004 21 21 16.3004 21 10.5C21 4.6996 16.3004 0 10.5 0C4.6996 0 0 4.6996 0 10.5ZM18.9677 10.5C18.9677 15.1996 15.1573 18.9677 10.5 18.9677C5.8004 18.9677 2.03226 15.1996 2.03226 10.5C2.03226 5.84274 5.8004 2.03226 10.5 2.03226C15.1573 2.03226 18.9677 5.84274 18.9677 10.5ZM14.3952 10.881C14.6069 10.6694 14.6069 10.373 14.3952 10.1613L9.1875 4.95363C9.01815 4.74194 8.67944 4.74194 8.46774 4.95363L7.53629 5.92742C7.3246 6.09677 7.3246 6.43548 7.53629 6.64718L11.3891 10.5L7.53629 14.3952C7.3246 14.6069 7.3246 14.9032 7.53629 15.1149L8.46774 16.0887C8.67944 16.2581 9.01815 16.2581 9.1875 16.0887L14.3952 10.881Z" fill="white"/>
                                </svg>                                    
                             </a>
                        </div>
                    </div>
                    <?php endwhile; ?>
                    <?php endif; ?>
                </div>
            </section>
            <section class="news_content">
                <div class="wrapper d_flex col_sec">
                    <div class="link_block d_flex">
                        <div class="green_title"></div>
                        <a class="title_link" href="/news/"> <?php _e( 'News', 'fintax' ); ?></a>
                    </div> 
                    <h4><?php _e( 'News from economic life', 'fintax' ); ?></h4>
                </div>
                <div class="news_slider_block">
                    <div class="slide_row">
                        <?php $args = array('post_type' => 'post', 'posts_per_page' => 24, 'order' => 'DESC',);
                        $loop = new WP_Query($args);
                        while ($loop->have_posts()) : $loop->the_post();?>
                        <a href="<?php the_permalink() ?>" class="slide_product d_flex">
                            <div class="slide_img min-height-img">
                                <?php the_post_thumbnail('full', array('class' => '')); ?>
                            </div>
                            <div class="d_flex slide_right">
                                <h6><?php the_title(); ?></h6>
                                <p>
                                     <?php the_excerpt();?>
                                </p>
                                <span><?php the_date(); ?></span>
                            </div>
                        </a>
                        <?php endwhile; ?>
                        <?php wp_reset_query(); ?>
                    </div>
                </div>
            </section>
            <section class="partner_block">
                <div class="wrapper">
                    <div class="d_flex col_sec">
                        <div class="link_block d_flex">
                            <div class="green_title"></div>
                            <span class="patners"> <?php _e( 'Partners', 'fintax' ); ?></span>
                        </div> 
                        <h5><?php _e( 'THEY TRUST US', 'fintax' ); ?></h5>
                    </div>
                </div>
                <div class="partners_slide wrapper" id="partners_slide">
                    <div class="news_slider_block">
                        <div class="grateful_area">
                            <?php if( have_rows('partners') ): ?>
                            <?php while( have_rows('partners') ): the_row(); 
                            $image = get_sub_field('image');
                            ?>
                            <a href="<?php the_sub_field('url'); ?>" class="slide_partners d_flex">
                                <div class="slide_img">
                                    <?php 
                        $image = get_sub_field('image');
                        if( !empty( $image ) ): ?>
                            <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
                        <?php endif; ?>
                                </div>
                            </a>
                        <?php endwhile; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </section>
            <section class="wrapper">
                <div class="question_block d_flex">
                   <div class="d_flex popup_blocks">
                         <?php echo do_shortcode('[contact-form-7 id="81" title="Form AM"]'); ?>
                        
                        
                    </div>
                    <div class="blue_underline"></div>
                    <div class="sky_underline"></div>
                </div>
            </section>
<?php get_footer(); ?>
